package com.instabug.library.networkinterception.sanitization

import com.instabug.library.Constants
import com.instabug.library.networkinterception.config.IBGNetworkInterceptionConfigurationProvider
import com.instabug.library.networkinterception.model.NetworkLogModel
import com.instabug.library.sanitize.Sanitizer
import com.instabug.library.util.InstabugSDKLogger

class HandleRequestAndResponseBodySanitizer(
    private val configurationProvider: IBGNetworkInterceptionConfigurationProvider
) : Sanitizer<NetworkLogModel.Builder> {
    override fun sanitize(item: NetworkLogModel.Builder): NetworkLogModel.Builder =
        runCatching {
            item.takeIf {
                !configurationProvider.shouldCaptureNetworkBodyLogs && (
                    item.requestBuilder?.body != null ||
                        item.responseBuilder?.body != null
             )
            }?.apply {
                shouldIgnoreRequestAndResponseBody(this)
            } ?: item
        }.getOrElse {
            InstabugSDKLogger.e(Constants.LOG_TAG, it.message.orEmpty(), it)
            item
        }

    private fun shouldIgnoreRequestAndResponseBody(item: NetworkLogModel.Builder): NetworkLogModel.Builder {
        item.requestBuilder?.setBody(null)
        item.responseBuilder?.setBody(null)
        return item
    }
}
