package com.instabug.library.networkinterception.sanitization

import com.instabug.library.networkinterception.config.IBGNetworkInterceptionConfigurationProvider
import com.instabug.library.networkinterception.delegate.validate.generateLargeBodyMessage
import com.instabug.library.networkinterception.model.NetworkLogModel
import com.instabug.library.sanitize.Sanitizer

class BodySizeSanitizer(
    private val configurationProvider: IBGNetworkInterceptionConfigurationProvider
) : Sanitizer<NetworkLogModel.Builder> {

    override fun sanitize(item: NetworkLogModel.Builder): NetworkLogModel.Builder = item.apply {
        requestBuilder?.apply {
            setBody(body?.sanitizeBody())
        }
        responseBuilder?.apply {
            setBody(body?.sanitizeBody())
        }
    }

    private fun String.sanitizeBody(): String = configurationProvider.v2MaxAllowedBodySizeBytes
        .let { maxSizeBytes ->
            takeIf { encodeToByteArray().size <= maxSizeBytes }
                ?: generateLargeBodyMessage(maxSizeBytes)
        }
}
