package com.instabug.library.networkinterception.okhttp.delegate.validate

import com.instabug.library.networkinterception.config.IBGNetworkInterceptionConfigurationProvider
import com.instabug.library.networkinterception.config.V2InterceptorFlags.Companion.RESPONSE_BODY_COLLECTION_ENABLED
import com.instabug.library.networkinterception.delegate.validate.DefaultResponseBodyValidator
import com.instabug.library.networkinterception.util.lcIsContentEncoded
import com.instabug.library.networkinterception.util.lcIsGZipped
import com.instabug.library.util.hasFlag

class OkHttpResponseBodyValidator(
    configurations: IBGNetworkInterceptionConfigurationProvider
) : DefaultResponseBodyValidator(configurations) {

    override fun invoke(headers: Map<String, String>, contentLength: Long): Pair<Boolean, String?> =
        takeIf { responseBodyCollectionEnabled }
            ?.let { super.invoke(headers, contentLength) } ?: (false to null)

    override fun Map<String, String>.encodingNotAllowed() =
        lcIsContentEncoded() && !lcIsGZipped()

    private val responseBodyCollectionEnabled
        get() = configurations.v2OkHttpInterceptorBEState.hasFlag(RESPONSE_BODY_COLLECTION_ENABLED)
}
