package com.instabug.library.networkinterception.okhttp.delegate

import com.instabug.library.internal.servicelocator.Provider
import com.instabug.library.networkinterception.NetworkInterceptionServiceLocator
import com.instabug.library.networkinterception.delegate.NetworkInterceptorDelegate
import com.instabug.library.util.extenstions.runOrLogError
import java.io.InputStream

class OkHttpInterceptorDelegateProvider :
    Provider<NetworkInterceptorDelegate<InputStream, InputStream>?> {

    override fun invoke(): NetworkInterceptorDelegate<InputStream, InputStream>? =
        runOrLogError {
            if (isV2OkHttpInterceptionEnabled()) {
                NetworkInterceptionServiceLocator.okHttpInterceptorDelegate
            } else {
                null
            }
        }.getOrNull()

    private fun isV2OkHttpInterceptionEnabled(): Boolean =
        with(NetworkInterceptionServiceLocator.configurationProvider) {
            v2OkHttpInterceptorBEState.isV2InterceptorEnabled()
        }
}
