package com.instabug.library.networkinterception.model.map

import com.instabug.library.logging.listeners.networklogs.NetworkLogSnapshot
import com.instabug.library.fill.Filler
import com.instabug.library.networkinterception.model.NetworkLogModel
import com.instabug.library.networkinterception.model.NetworkLogRequestModel
import com.instabug.library.networkinterception.model.NetworkLogResponseModel

class NetworkSnapshotToNetworkLogBuilderFiller :
    Filler<NetworkLogModel.Builder, NetworkLogSnapshot> {
    override fun NetworkLogModel.Builder.fill(
        from: NetworkLogSnapshot
    ) {
        setUserModified(isModifiedComparedTo(from))
        from.url?.let { setUrl(it) }

        getOrCreateRequestBuilder().run {
            setHeaders(from.requestHeaders.map())
            setBody(from.requestBody)
        }

        getOrCreateResponseBuilder().run {
            setHeaders(from.responseHeaders.map())
            setBody(from.response)
            setResponseCode(from.responseCode)
        }
    }

    private fun NetworkLogModel.Builder.getOrCreateRequestBuilder() =
        requestBuilder ?: NetworkLogRequestModel.Builder().also { setRequestBuilder(it) }

    private fun NetworkLogModel.Builder.getOrCreateResponseBuilder() =
        responseBuilder ?: NetworkLogResponseModel.Builder().also { setResponseBuilder(it) }

    private fun MutableMap<String, Any?>?.map(): MutableMap<String, String>? =
        this?.takeIf { it.isNotEmpty() }?.mapValuesTo(HashMap()) { it.value.toString() }

    private fun NetworkLogModel.Builder.isModifiedComparedTo(from: NetworkLogSnapshot): Boolean {
        return from.url != url ||
            from.requestHeaders.map() != requestBuilder?.headers ||
            from.requestBody != requestBuilder?.body ||
            from.responseHeaders.map() != responseBuilder?.headers ||
            from.response != responseBuilder?.body
    }
}
