package com.instabug.library.networkinterception.model.map

import com.instabug.library.logging.listeners.networklogs.NetworkLogSnapshot
import com.instabug.library.map.Mapper
import com.instabug.library.networkinterception.model.NetworkLogModel

class NetworkLogBuilderToSnapshotMapper : Mapper<NetworkLogModel.Builder, NetworkLogSnapshot> {

    override fun map(from: NetworkLogModel.Builder): NetworkLogSnapshot =
        NetworkLogSnapshot(
            url = from.url,
            requestHeaders = from.requestBuilder?.headers?.map(),
            requestBody = from.requestBuilder?.body,
            responseHeaders = from.responseBuilder?.headers?.map(),
            response = from.responseBuilder?.body,
            responseCode = from.responseBuilder?.responseCode ?: 0
        )

    private fun Map<String, String>.map(): MutableMap<String, Any?> =
        mapValuesTo(HashMap()) { it.value }
}
