package com.instabug.library.networkinterception.gql.model

import com.instabug.library.networkinterception.model.NetworkLogResponseModel

class GqlNetworkLogResponseModel : NetworkLogResponseModel {

    private constructor() : super()
    private constructor(origin: NetworkLogResponseModel) : super(origin) {
        if (origin is GqlNetworkLogResponseModel) {
            isServerError = origin.isServerError
        }
    }

    var isServerError: Boolean = false
        private set

    override fun newBuilder(): Builder = Builder(GqlNetworkLogResponseModel(this))

    class Builder internal constructor(
        private val holder: GqlNetworkLogResponseModel
    ) : NetworkLogResponseModel.Builder(holder) {
        constructor() : this(GqlNetworkLogResponseModel())
        constructor(baseModel: NetworkLogResponseModel) : this(GqlNetworkLogResponseModel(baseModel))

        fun setIsServerError(isServerError: Boolean): Builder = apply {
            holder.isServerError = isServerError
        }

        val isServerError: Boolean
            get() = holder.isServerError

        override fun build(): GqlNetworkLogResponseModel = holder
    }
}
