package com.instabug.library.networkinterception.dispatch

import com.instabug.library.networkinterception.model.NetworkLogModel
import java.util.Collections
import java.util.HashSet

class SynchronousNetworkLogDispatcher : NetworkLogDispatcher, NetworkLogReceiverRegistry {

    private val receivers: MutableSet<NetworkLogReceiver> =
        Collections.synchronizedSet(HashSet())

    override fun addReceiver(receiver: NetworkLogReceiver) {
        receivers += receiver
    }

    override fun removeReceiver(receiver: NetworkLogReceiver) {
        receivers -= receiver
    }

    override fun onNetworkRequestStarted(reference: Any) = dispatchEvent {
        it.onNetworkRequestStarted(reference)
    }

    override fun onNetworkLogCreated(reference: Any, model: NetworkLogModel) = dispatchEvent {
        it.onNetworkLogCreated(reference, model)
    }

    private inline fun dispatchEvent(event: (NetworkLogReceiver) -> Unit) {
        synchronized(receivers) {
            receivers.forEach {
                runCatching { event(it) }
            }
        }
    }
}
