package com.instabug.library.networkinterception.dispatch

import com.instabug.library.networkinterception.model.NetworkLogModel

/**
 * Dispatcher for network log events
 */
interface NetworkLogDispatcher {

    /**
     * Network request started and data collection started
     * @param reference reference object that uniquely identifies events related to a certain network log
     */
    fun onNetworkRequestStarted(reference: Any)

    /**
     * Network request completed, and network log model has been created for it
     * @param reference reference object that uniquely identifies events related to a certain network log
     */
    fun onNetworkLogCreated(reference: Any, model: NetworkLogModel)
}

/**
 * Registry for NetworkLog receiver
 */
interface NetworkLogReceiverRegistry {

    fun addReceiver(receiver: NetworkLogReceiver)

    fun removeReceiver(receiver: NetworkLogReceiver)

    operator fun plusAssign(receiver: NetworkLogReceiver) = addReceiver(receiver)

    operator fun minusAssign(receiver: NetworkLogReceiver) = removeReceiver(receiver)
}

interface NetworkLogReceiver {

    /**
     * Network request started and data collection started
     * @param reference reference object that uniquely identifies events related to a certain network log
     */
    fun onNetworkRequestStarted(reference: Any)

    /**
     * Network request completed, and network log model has been created for it
     * @param reference reference object that uniquely identifies events related to a certain network log
     */
    fun onNetworkLogCreated(reference: Any, model: NetworkLogModel)
}
