package com.instabug.library.networkinterception.delegate.extract

import com.instabug.library.factory.ParameterizedFactory
import com.instabug.library.networkinterception.config.IBGNetworkInterceptionConfigurationProvider
import com.instabug.library.networkinterception.delegate.Utf8CodePointEvaluator
import java.io.OutputStream

class OutputStreamWrapperFactory(
    private val configurations: IBGNetworkInterceptionConfigurationProvider,
    private val plainTextSampleSize: Int,
    private val utf8CodePointEvaluator: Utf8CodePointEvaluator
) : ParameterizedFactory<OutputStream, OutputStreamWrapperFactoryParam> {

    override fun create(type: OutputStreamWrapperFactoryParam): OutputStream =
        OutputStreamWrapper(
            delegate = type.delegateStream,
            plaintTextOutputStream = PlainTextByteArrayOutputStream(
                sampleSizeBytes = plainTextSampleSize,
                maxAllowedSizeBytes = configurations.v2MaxAllowedBodySizeBytes,
                utf8CodePointEvaluator = utf8CodePointEvaluator
            ),
            onBodyReady = type.onBodyReady

        )
}

class OutputStreamWrapperFactoryParam(
    val delegateStream: OutputStream,
    val onBodyReady: (body: String?, length: Long?) -> Unit
)
