package com.instabug.library.networkinterception.delegate.extract

import java.io.OutputStream

class OutputStreamWrapper(
    private val delegate: OutputStream,
    private val plaintTextOutputStream: PlainTextByteArrayOutputStream,
    private val onBodyReady: (body: String?, length: Long?) -> Unit
) : OutputStream() {

    override fun close() = dispatch { close() }.also { dispatchResult() }

    override fun flush() = dispatch { flush() }

    override fun write(b: Int) = dispatch { write(b) }

    override fun write(b: ByteArray?) = dispatch { write(b) }

    override fun write(b: ByteArray?, off: Int, len: Int) = dispatch { write(b, off, len) }

    private inline fun dispatch(event: (OutputStream.() -> Unit)) {
        delegate.event()
        plaintTextOutputStream.event()
    }

    private fun dispatchResult() {
        onBodyReady(
            plaintTextOutputStream.generateBodyText(),
            plaintTextOutputStream.byteCount
        )
    }
}
