package com.instabug.library.networkinterception.config

import androidx.annotation.IntDef
import com.instabug.library.networkinterception.config.V2InterceptorFlags.Companion.ENABLED
import com.instabug.library.networkinterception.config.V2InterceptorFlags.Companion.REQUEST_BODY_COLLECTION_ENABLED
import com.instabug.library.networkinterception.config.V2InterceptorFlags.Companion.RESPONSE_BODY_COLLECTION_ENABLED

@Retention(AnnotationRetention.SOURCE)
@IntDef(
    ENABLED,
    REQUEST_BODY_COLLECTION_ENABLED,
    RESPONSE_BODY_COLLECTION_ENABLED
)
annotation class V2InterceptorFlags {
    companion object {
        const val ENABLED = 0B0001
        const val REQUEST_BODY_COLLECTION_ENABLED = 0B0010
        const val RESPONSE_BODY_COLLECTION_ENABLED = 0B0100
    }
}
