package com.instabug.library.networkinterception

import com.instabug.library.networkinterception.config.IBGNetworkInterceptionConfigurationProvider
import com.instabug.library.networkinterception.dispatch.NetworkLogDispatcher
import com.instabug.library.networkinterception.model.NetworkLogModel
import com.instabug.library.sanitize.Sanitizer
import java.util.concurrent.Executor

class NetworkLogProcessorImpl(
    private val configurationProvider: IBGNetworkInterceptionConfigurationProvider,
    private val sanitizer: Sanitizer<NetworkLogModel.Builder>,
    private val dispatcher: NetworkLogDispatcher,
    private val executor: Executor
) : NetworkLogProcessor {

    override fun onNetworkRequestStarted(reference: Any) = executor.execute {
        dispatcher.takeIf { configurationProvider.networkInterceptionV2Enabled }
            ?.onNetworkRequestStarted(reference)
    }

    override fun processNetworkLog(reference: Any, builder: NetworkLogModel.Builder) =
        executor.execute {
            sanitizer.takeIf { configurationProvider.networkInterceptionV2Enabled }
                ?.sanitize(builder)
                ?.build()
                ?.let { dispatcher.onNetworkLogCreated(reference, it) }
        }
}
