package com.instabug.library.internal.video;

import android.net.Uri;

import androidx.annotation.Nullable;

/**
 * Created by vezikon on 6/11/17.
 */

public class ScreenRecordingEvent {

    public static final int RECORDING_PERMISSION_DENIED = 0;
    public static final int RECORDING_FINISHED = 1;
    public static final int RECORDING_FILE_READY = 2;
    public static final int RECORDING_CANCELED = 3;
    public static final int RECORDING_ERROR = 4;
    private final int status;
    @Nullable
    private final Uri videoUri;

    private int videoDuration = -1;

    public ScreenRecordingEvent(int status, @Nullable Uri videoUri, int videoDuration) {
        this(status, videoUri);
        this.videoDuration = videoDuration;
    }

    public ScreenRecordingEvent(int status, @Nullable Uri videoUri) {
        this.status = status;
        this.videoUri = videoUri;
    }

    public int getVideoDuration() {
        return videoDuration;
    }

    public int getStatus() {
        return status;
    }

    @Nullable
    public Uri getVideoUri() {
        return videoUri;
    }
}
