package com.instabug.library.internal.storage.cache.db.migrations;

import android.database.sqlite.SQLiteDatabase;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;

import com.instabug.library.internal.storage.cache.db.InstabugDbContract;

import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.BOOLEAN_TYPE;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.COMMA_SEP;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.DEFAULT;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.INTEGER_TYPE;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SurveyEntry.COLUMN_ANSWERED;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SurveyEntry.COLUMN_ATTEMPT_COUNT;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SurveyEntry.COLUMN_CONDITIONS_OPERATOR;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SurveyEntry.COLUMN_CUSTOM_ATTRIBUTES;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SurveyEntry.COLUMN_DISMISSED_AT;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SurveyEntry.COLUMN_EVENT_INDEX;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SurveyEntry.COLUMN_GOOGLE_PLAY_RATING;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SurveyEntry.COLUMN_ID;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SurveyEntry.COLUMN_IS_CANCELLED;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SurveyEntry.COLUMN_PAUSED;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SurveyEntry.COLUMN_QUESTIONS;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SurveyEntry.COLUMN_SESSIONS_COUNT;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SurveyEntry.COLUMN_SHOULD_SHOW_AGAIN;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SurveyEntry.COLUMN_SHOWN_AT;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SurveyEntry.COLUMN_SURVEY_CURRENT_LOCALE;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SurveyEntry.COLUMN_SURVEY_IS_LOCALIZED;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SurveyEntry.COLUMN_SURVEY_LOCALES;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SurveyEntry.COLUMN_SURVEY_STATE;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SurveyEntry.COLUMN_SURVEY_TARGET;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SurveyEntry.COLUMN_SURVEY_TRIGGER_EVENT;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SurveyEntry.COLUMN_TARGET_AUDIENCES;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SurveyEntry.COLUMN_THANKS_LIST;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SurveyEntry.COLUMN_TITLE;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SurveyEntry.COLUMN_TOKEN;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SurveyEntry.COLUMN_TYPE;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.SurveyEntry.COLUMN_USER_EVENTS;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.TEXT_TYPE;

public class Migration_22_23 implements Migration {

    @Override
    public void migrate(SQLiteDatabase db) {
        // SQLite does not fully support ALTER TABLE statements. The workaround to altering an
        // existing column's type is to create a new table with a temporary name, copy everything to
        // the new table, drop the old table and then rename the new table to its original name.
        String originalTableName = InstabugDbContract.SurveyEntry.TABLE_NAME;
        String tempTableName = InstabugDbContract.SurveyEntry.TABLE_NAME + "_temp";
        // create new table with temp name.
        createTable(db, tempTableName);
        // copy values from old table to new table.
        copyValues(db, originalTableName, tempTableName, getColumnsCommaSeparated());
        // drop old table.
        dropTable(db, originalTableName);
        // rename the new table to its original name.
        renameTable(db, tempTableName, originalTableName);
    }

    @VisibleForTesting
    public void createTable(@NonNull SQLiteDatabase db, @NonNull String tableName) {
        db.execSQL("CREATE TABLE IF NOT EXISTS " + tableName + " ( "
                + COLUMN_ID + INTEGER_TYPE + " PRIMARY KEY" + COMMA_SEP
                + COLUMN_TYPE + INTEGER_TYPE + COMMA_SEP
                + COLUMN_GOOGLE_PLAY_RATING + INTEGER_TYPE + DEFAULT + "0 " + COMMA_SEP // new column
                + COLUMN_TITLE + TEXT_TYPE + COMMA_SEP
                + COLUMN_TOKEN + TEXT_TYPE + COMMA_SEP
                + COLUMN_CONDITIONS_OPERATOR + TEXT_TYPE + COMMA_SEP
                + COLUMN_ANSWERED + INTEGER_TYPE + COMMA_SEP
                + COLUMN_DISMISSED_AT + INTEGER_TYPE + COMMA_SEP
                + COLUMN_SHOWN_AT + INTEGER_TYPE + COMMA_SEP
                + COLUMN_IS_CANCELLED + INTEGER_TYPE + COMMA_SEP
                + COLUMN_ATTEMPT_COUNT + INTEGER_TYPE + COMMA_SEP
                + COLUMN_EVENT_INDEX + INTEGER_TYPE + COMMA_SEP
                + COLUMN_SHOULD_SHOW_AGAIN + INTEGER_TYPE + COMMA_SEP
                + COLUMN_PAUSED + INTEGER_TYPE + COMMA_SEP
                + COLUMN_SESSIONS_COUNT + INTEGER_TYPE + COMMA_SEP
                + COLUMN_QUESTIONS + TEXT_TYPE + COMMA_SEP
                + COLUMN_THANKS_LIST + TEXT_TYPE + COMMA_SEP
                + COLUMN_TARGET_AUDIENCES + TEXT_TYPE + COMMA_SEP
                + COLUMN_CUSTOM_ATTRIBUTES + TEXT_TYPE + COMMA_SEP
                + COLUMN_USER_EVENTS + TEXT_TYPE + COMMA_SEP
                + COLUMN_SURVEY_STATE + TEXT_TYPE + COMMA_SEP
                + COLUMN_SURVEY_TARGET + TEXT_TYPE + COMMA_SEP
                + COLUMN_SURVEY_TRIGGER_EVENT + TEXT_TYPE + COMMA_SEP
                + COLUMN_SURVEY_IS_LOCALIZED + BOOLEAN_TYPE + COMMA_SEP
                + COLUMN_SURVEY_CURRENT_LOCALE + TEXT_TYPE + COMMA_SEP
                + COLUMN_SURVEY_LOCALES + TEXT_TYPE
                + ")"
        );
    }

    @VisibleForTesting
    public void copyValues(SQLiteDatabase db, String oldTable, String newTable, String columns) {
        db.execSQL("INSERT INTO " + newTable + "(" + columns + ")"
                + " SELECT " + columns
                + " FROM " + oldTable);
    }

    @VisibleForTesting
    public void dropTable(SQLiteDatabase db, String tableName) {
        db.execSQL("DROP TABLE IF EXISTS " + tableName);
    }

    @VisibleForTesting
    public void renameTable(SQLiteDatabase db, String oldTableName, String newTableName) {
        db.execSQL("ALTER TABLE " + oldTableName + " RENAME TO " + newTableName);
    }

    @VisibleForTesting
    public String getColumnsCommaSeparated() {
        return COLUMN_ID + COMMA_SEP
                + COLUMN_TYPE + COMMA_SEP
                + COLUMN_TITLE + COMMA_SEP
                + COLUMN_TOKEN + COMMA_SEP
                + COLUMN_CONDITIONS_OPERATOR + COMMA_SEP
                + COLUMN_ANSWERED + COMMA_SEP
                + COLUMN_DISMISSED_AT + COMMA_SEP
                + COLUMN_SHOWN_AT + COMMA_SEP
                + COLUMN_IS_CANCELLED + COMMA_SEP
                + COLUMN_ATTEMPT_COUNT + COMMA_SEP
                + COLUMN_EVENT_INDEX + COMMA_SEP
                + COLUMN_SHOULD_SHOW_AGAIN + COMMA_SEP
                + COLUMN_PAUSED + COMMA_SEP
                + COLUMN_SESSIONS_COUNT + COMMA_SEP
                + COLUMN_QUESTIONS + COMMA_SEP
                + COLUMN_THANKS_LIST + COMMA_SEP
                + COLUMN_TARGET_AUDIENCES + COMMA_SEP
                + COLUMN_CUSTOM_ATTRIBUTES + COMMA_SEP
                + COLUMN_USER_EVENTS + COMMA_SEP
                + COLUMN_SURVEY_STATE + COMMA_SEP
                + COLUMN_SURVEY_TARGET + COMMA_SEP
                + COLUMN_SURVEY_TRIGGER_EVENT + COMMA_SEP
                + COLUMN_SURVEY_IS_LOCALIZED + COMMA_SEP
                + COLUMN_SURVEY_LOCALES + COMMA_SEP
                + COLUMN_SURVEY_CURRENT_LOCALE;
    }
}
