package com.instabug.library.internal.contentprovider;

import android.app.Application;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class InstabugApplicationProvider {
    @Nullable
    private static InstabugApplicationProvider INSTANCE;
    @NonNull
    private final Application application;

    private InstabugApplicationProvider(@NonNull Application application) {
        this.application = application;
    }

    public static void init(Application application) {
        if (INSTANCE == null) {
            INSTANCE = new InstabugApplicationProvider(application);
        }
    }

    @Nullable
    public static InstabugApplicationProvider getInstance() {
        return INSTANCE;
    }

    @NonNull
    public Application getApplication() {
        return application;
    }
}
