package com.instabug.library.diagnostics.diagnostics_db.migration

import android.database.sqlite.SQLiteDatabase
import com.instabug.library.diagnostics.diagnostics_db.*
import com.instabug.library.internal.storage.cache.dbv2.migration.BaseDBMigrationImpl
import com.instabug.library.internal.storage.cache.dbv2.migration.BaseDbMigration

class DiagnosticsDBMigrationV3(override val db: SQLiteDatabase) : BaseDBMigrationImpl(db) {
    override val previous: BaseDbMigration?
        get() = DiagnosticsDBMigrationV2(db)
    override val version: Int
        get() = DB_V3

    override fun execute() = runLogic {
        db.execSQL(CustomTracesEntry.CREATE_TABLE)
        db.execSQL(CustomTracesAttributesEntry.CREATE_TABLE)
    }
}