/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.ui.custom;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.view.View;
import android.view.Window;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import com.instabug.library.R;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.model.IBGTheme;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.AccessibilityUtils;
import com.instabug.library.util.AttrResolver;
import com.instabug.library.util.ThemeApplier;
import com.instabug.library.util.UiUtils;

public class InstabugAlertDialog {

    public static class Builder {
        @NonNull
        private final Activity activity;
        @Nullable
        private String title;
        @Nullable
        private String message;
        @Nullable
        private String positiveButtonText;
        @Nullable
        private String negativeButtonText;
        @Nullable
        private DialogInterface.OnClickListener onPositiveClickListener;
        @Nullable
        private DialogInterface.OnClickListener onNegativeClickListener;
        @Nullable
        private String positiveButtonAccessibilityContentDescription;
        @Nullable
        private String negativeButtonAccessibilityContentDescription;
        private boolean isCancellable = true;

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull Activity activity) {
            void var1_1;
            this.activity = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private int getBackgroundColor(Activity activity) {
            void var1_1;
            IBGTheme iBGTheme = SettingsManager.getInstance().getIBGTheme();
            if (iBGTheme != null && iBGTheme.getBackgroundColor() != -1) {
                return iBGTheme.getBackgroundColor();
            }
            return AttrResolver.getBackgroundColor((Context)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private /* synthetic */ void lambda$show$2(AlertDialog alertDialog, DialogInterface dialog) {
            void var1_1;
            AlertDialog alertDialog2 = alertDialog;
            ThemeApplier.applyCtaStyle(alertDialog2.getButton(-1), SettingsManager.getInstance().getIBGTheme());
            ThemeApplier.applyCtaStyle(alertDialog2.getButton(-2), SettingsManager.getInstance().getIBGTheme());
            TextView textView = (TextView)alertDialog2.findViewById(R.id.alertTitle);
            TextView textView2 = (TextView)var1_1.findViewById(16908299);
            View view = var1_1.findViewById(R.id.parentPanel);
            ThemeApplier.applyPrimaryTextStyle(textView, SettingsManager.getInstance().getIBGTheme());
            ThemeApplier.applySecondaryTextStyle(textView2, SettingsManager.getInstance().getIBGTheme());
            if (textView != null && Build.VERSION.SDK_INT >= 17) {
                textView.setTextAlignment(2);
            }
            if (view != null) {
                Builder builder = this;
                view.setBackgroundColor(builder.getBackgroundColor(builder.activity));
            }
            if (AccessibilityUtils.isTalkbackEnabled()) {
                void v3 = var1_1;
                v3.getButton(-1).setContentDescription((CharSequence)this.positiveButtonAccessibilityContentDescription);
                v3.getButton(-2).setContentDescription((CharSequence)this.negativeButtonAccessibilityContentDescription);
                if (textView != null && Build.VERSION.SDK_INT >= 28) {
                    TextView textView3 = textView;
                    textView3.setImportantForAccessibility(1);
                    textView3.setScreenReaderFocusable(true);
                    return;
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        public Builder setTitle(@Nullable String title) {
            void var1_1;
            this.title = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setMessage(@Nullable String message) {
            void var1_1;
            this.message = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setPositiveButton(@Nullable String positiveButtonText, @Nullable DialogInterface.OnClickListener onPositiveClickListener) {
            void var2_2;
            void var1_1;
            this.positiveButtonText = var1_1;
            this.onPositiveClickListener = var2_2;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setNegativeButton(@Nullable String negativeButtonText, @Nullable DialogInterface.OnClickListener onNegativeClickListener) {
            void var2_2;
            void var1_1;
            this.negativeButtonText = var1_1;
            this.onNegativeClickListener = var2_2;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setCancellable(boolean cancellable) {
            void var1_1;
            this.isCancellable = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setPositiveButtonAccessibilityContentDescription(@Nullable String positiveButtonAccessibilityContentDescription) {
            void var1_1;
            this.positiveButtonAccessibilityContentDescription = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setNegativeButtonAccessibilityContentDescription(@Nullable String negativeButtonAccessibilityContentDescription) {
            void var1_1;
            this.negativeButtonAccessibilityContentDescription = var1_1;
            return this;
        }

        public AlertDialog show() {
            DialogInterface.OnClickListener onClickListener;
            AlertDialog.Builder builder;
            AlertDialog.Builder builder2 = builder;
            builder2((Context)this.activity, R.style.InstabugDialogStyle);
            builder.setTitle((CharSequence)this.title).setMessage((CharSequence)this.message).setCancelable(this.isCancellable);
            if (this.positiveButtonText != null) {
                onClickListener = this.onPositiveClickListener;
                if (onClickListener == null) {
                    onClickListener = (dialogInterface, i2) -> dialogInterface.dismiss();
                }
                builder2.setPositiveButton((CharSequence)this.positiveButtonText, onClickListener);
            }
            if (this.negativeButtonText != null) {
                onClickListener = this.onNegativeClickListener;
                if (onClickListener == null) {
                    onClickListener = (dialogInterface, i2) -> dialogInterface.cancel();
                }
                builder2.setNegativeButton((CharSequence)this.negativeButtonText, onClickListener);
            }
            builder2 = builder2.create();
            onClickListener = builder2.getWindow();
            if (InstabugCore.isFullScreen() && onClickListener != null) {
                onClickListener.setFlags(8, 8);
            }
            builder2.setOnShowListener(arg_0 -> this.lambda$show$2((AlertDialog)builder2, arg_0));
            if (Build.VERSION.SDK_INT >= 17) {
                if (!this.activity.isFinishing() && !this.activity.isDestroyed()) {
                    builder2.show();
                }
            } else if (!this.activity.isFinishing()) {
                builder2.show();
            }
            if (InstabugCore.isFullScreen() && onClickListener != null) {
                DialogInterface.OnClickListener onClickListener2 = onClickListener;
                UiUtils.showInFullscreen((Window)onClickListener2);
                onClickListener2.clearFlags(8);
                return builder2;
            }
            return builder2;
        }
    }
}

