/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.screenshot.analytics;

import androidx.annotation.VisibleForTesting;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.eventpublisher.Subscriber;
import com.instabug.library.screenshot.analytics.AnalyticsEvent;
import com.instabug.library.screenshot.analytics.ScreenshotAnalytics;
import com.instabug.library.screenshot.analytics.ScreenshotsAnalyticsHolder;
import com.instabug.library.visualusersteps.ReproConfigurationsProvider;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J \u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/instabug/library/screenshot/analytics/ProductAnalyticsCollector;", "Lcom/instabug/library/screenshot/analytics/ScreenshotsAnalyticsHolder;", "Lcom/instabug/library/core/eventbus/eventpublisher/Subscriber;", "Lcom/instabug/library/screenshot/analytics/AnalyticsEvent;", "analyticsHolder", "reproConfigurations", "Lcom/instabug/library/visualusersteps/ReproConfigurationsProvider;", "(Lcom/instabug/library/screenshot/analytics/ScreenshotsAnalyticsHolder;Lcom/instabug/library/visualusersteps/ReproConfigurationsProvider;)V", "previousIsFeatureAvailable", "", "previousReproScreenshotsAvailable", "previousReproScreenshotsEnabled", "previousReproStepsEnabled", "productErrors", "", "", "Ljava/util/concurrent/atomic/AtomicInteger;", "getProductErrors$annotations", "()V", "getProductErrors", "()Ljava/util/Map;", "adjustRSADisabledBEErrorCodes", "reproAuthId", "", "adjustReproStepsDisabledSDKErrorCodes", "adjustScreenShotDisabledSDKErrorCodes", "getAnalytics", "Lcom/instabug/library/screenshot/analytics/ScreenshotAnalytics;", "handleConfigurations", "", "onNewEvent", "event", "updateFeatureState", "currentState", "previousState", "errorCode", "instabug-core_defaultUiRelease"})
@SourceDebugExtension(value={"SMAP\nProductAnalyticsCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProductAnalyticsCollector.kt\ncom/instabug/library/screenshot/analytics/ProductAnalyticsCollector\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,102:1\n361#2,7:103\n*S KotlinDebug\n*F\n+ 1 ProductAnalyticsCollector.kt\ncom/instabug/library/screenshot/analytics/ProductAnalyticsCollector\n*L\n70#1:103,7\n*E\n"})
public final class ProductAnalyticsCollector
implements ScreenshotsAnalyticsHolder,
Subscriber<AnalyticsEvent> {
    @NotNull
    private final ScreenshotsAnalyticsHolder analyticsHolder;
    @NotNull
    private final ReproConfigurationsProvider reproConfigurations;
    @NotNull
    private final Map<String, AtomicInteger> productErrors;
    private boolean previousReproStepsEnabled;
    private boolean previousReproScreenshotsEnabled;
    private boolean previousReproScreenshotsAvailable;
    private boolean previousIsFeatureAvailable;

    /*
     * WARNING - void declaration
     */
    public ProductAnalyticsCollector(@NotNull ScreenshotsAnalyticsHolder analyticsHolder, @NotNull ReproConfigurationsProvider reproConfigurations) {
        LinkedHashMap linkedHashMap;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"analyticsHolder");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"reproConfigurations");
        ((ProductAnalyticsCollector)((Object)this_)).analyticsHolder = var1_1;
        ((ProductAnalyticsCollector)((Object)this_)).reproConfigurations = var2_2;
        LinkedHashMap this_ = linkedHashMap;
        linkedHashMap = new LinkedHashMap();
        v1.productErrors = this_;
        v1.previousReproStepsEnabled = true;
        v1.previousReproScreenshotsEnabled = true;
        v1.previousReproScreenshotsAvailable = true;
        v1.previousIsFeatureAvailable = true;
    }

    @VisibleForTesting
    public static /* synthetic */ void getProductErrors$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    private final boolean updateFeatureState(boolean currentState, boolean previousState, String errorCode) {
        void var1_1;
        void var2_2;
        if (!currentState && var2_2 != false) {
            void var3_4;
            Map<String, AtomicInteger> map = ((ProductAnalyticsCollector)((Object)map)).productErrors;
            AtomicInteger atomicInteger = map.get(var3_4);
            if (atomicInteger == null) {
                AtomicInteger atomicInteger2;
                atomicInteger = atomicInteger2;
                atomicInteger2 = new AtomicInteger();
                map.put((String)var3_4, atomicInteger);
            }
            atomicInteger.incrementAndGet();
            return (boolean)var1_1;
        }
        return (boolean)var1_1;
    }

    private final String adjustReproStepsDisabledSDKErrorCodes(int reproAuthId) {
        if (reproAuthId == 1) {
            return "5881";
        }
        return "5882";
    }

    private final String adjustScreenShotDisabledSDKErrorCodes(int reproAuthId) {
        if (reproAuthId == 1) {
            return "5861";
        }
        return "5862";
    }

    private final String adjustRSADisabledBEErrorCodes(int reproAuthId) {
        if (reproAuthId == 1) {
            return "5851";
        }
        return "5852";
    }

    @NotNull
    public final Map<String, AtomicInteger> getProductErrors() {
        return this.productErrors;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onNewEvent(@NotNull AnalyticsEvent event) {
        void var1_1;
        AnalyticsEvent analyticsEvent = event;
        Intrinsics.checkNotNullParameter((Object)analyticsEvent, (String)"event");
        if (analyticsEvent instanceof AnalyticsEvent.ScreenshotEvent.OnConfigurationChanged) {
            this.handleConfigurations();
        }
        if (var1_1 instanceof AnalyticsEvent.a) {
            this.productErrors.clear();
            this.previousIsFeatureAvailable = true;
            this.previousReproStepsEnabled = true;
            this.previousReproScreenshotsEnabled = true;
            this.previousReproScreenshotsAvailable = true;
            return;
        }
    }

    public final void handleConfigurations() {
        boolean bl = this.previousIsFeatureAvailable;
        this.previousIsFeatureAvailable = this.updateFeatureState(InstabugCore.isFeatureAvailable("REPRO_STEPS"), bl, "587");
        bl = this.previousReproStepsEnabled;
        String string2 = this.adjustReproStepsDisabledSDKErrorCodes(this.reproConfigurations.getReproProxyAuthId());
        this.previousReproStepsEnabled = this.updateFeatureState(this.reproConfigurations.isReproStepsEnabledSDK(), bl, string2);
        if (this.previousReproStepsEnabled) {
            bl = this.previousReproScreenshotsEnabled;
            string2 = this.adjustScreenShotDisabledSDKErrorCodes(this.reproConfigurations.getReproProxyAuthId());
            this.updateFeatureState(this.reproConfigurations.isReproScreenShotsEnabledSDK(), bl, string2);
        }
        this.previousReproScreenshotsEnabled = this.reproConfigurations.isReproScreenShotsEnabledSDK();
        bl = this.previousReproScreenshotsAvailable;
        string2 = this.adjustRSADisabledBEErrorCodes(this.reproConfigurations.getReproProxyAuthId());
        this.previousReproScreenshotsAvailable = this.updateFeatureState(this.reproConfigurations.isReproScreenshotsAvailable(), bl, string2);
    }

    @Override
    @NotNull
    public ScreenshotAnalytics getAnalytics() {
        ScreenshotAnalytics screenshotAnalytics;
        if (this.reproConfigurations.isReproScreenshotsEnabled()) {
            screenshotAnalytics = this.analyticsHolder.getAnalytics();
        } else {
            ScreenshotAnalytics screenshotAnalytics2;
            screenshotAnalytics = screenshotAnalytics2;
            screenshotAnalytics2 = new ScreenshotAnalytics(null, null, null, 7, null);
        }
        ScreenshotAnalytics screenshotAnalytics3 = screenshotAnalytics;
        screenshotAnalytics3.adjustErrorCodes(this.productErrors);
        return screenshotAnalytics3;
    }
}

