/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.logging;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.instabug.library.Feature;
import com.instabug.library.Instabug;
import com.instabug.library.core.eventbus.UserEventsEventBus;
import com.instabug.library.d;
import com.instabug.library.internal.storage.cache.user.UserCacheManager;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.user.UserEvent;
import com.instabug.library.user.UserEventParam;
import com.instabug.library.user.e;
import com.instabug.library.util.InstabugDateFormatter;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class InstabugUserEventLogger {
    private static volatile InstabugUserEventLogger instabugUserEventLogger;
    private static final int USER_EVENT_COUNT_LIMIT = 1000;
    private List<UserEvent> userEvents;
    private ConcurrentHashMap<String, Integer> userEventsCount;

    private InstabugUserEventLogger() {
        ConcurrentHashMap concurrentHashMap;
        CopyOnWriteArrayList copyOnWriteArrayList;
        Object this_ = copyOnWriteArrayList;
        copyOnWriteArrayList = new CopyOnWriteArrayList();
        v1.userEvents = this_;
        this_ = concurrentHashMap;
        concurrentHashMap = new ConcurrentHashMap();
        v1.userEventsCount = this_;
    }

    public static synchronized InstabugUserEventLogger getInstance() {
        if (instabugUserEventLogger == null) {
            instabugUserEventLogger = new InstabugUserEventLogger();
        }
        return instabugUserEventLogger;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    private void runInsertionHandlerAvailable(String uuid, boolean anonymous) {
        Throwable throwable2;
        block5: {
            if (Instabug.getApplicationContext() == null) {
                return;
            }
            try {
                for (Map.Entry<String, Integer> entry : this.userEventsCount.entrySet()) {
                    void var2_3;
                    void var1_2;
                    this.incrementEventLoggingCount(entry.getKey(), entry.getValue(), (String)var1_2, (boolean)var2_3);
                }
            }
            catch (Throwable throwable2) {
                break block5;
            }
            this.userEventsCount.clear();
            return;
        }
        InstabugSDKLogger.e("IBG-Core", "Error: " + throwable2.getMessage() + "while inserting user events");
    }

    /*
     * WARNING - void declaration
     */
    private void incrementEventLoggingCount(@NonNull String eventIdentifier, int incrementBy, String uuid, boolean anonymous) {
        void var4_5;
        void var3_4;
        void var2_3;
        void var1_2;
        int n2 = com.instabug.library.logging.a.b((String)var1_2, e.i()) + var2_3;
        if (com.instabug.library.internal.storage.cache.user.a.a(uuid) == null) {
            UserCacheManager.insertIfNotExists((String)var3_4, SettingsManager.getInstance().getSessionsCount());
        }
        com.instabug.library.logging.a.a((String)var1_2, n2, (String)var3_4, (boolean)var4_5);
        UserEventsEventBus.getInstance().post(new UserEvent().setEventIdentifier((String)var1_2));
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$200(InstabugUserEventLogger x02, String x12, boolean x2) {
        void var2_2;
        void var1_1;
        x02.runInsertionHandlerAvailable((String)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void logUserEvent(@NonNull String eventIdentifier, UserEventParam ... userEventParams) {
        void var2_2;
        void var1_1;
        PoolProvider.getUserActionsExecutor().execute(new Runnable(this, (String)var1_1, (UserEventParam[])var2_2){
            final /* synthetic */ String a;
            final /* synthetic */ UserEventParam[] b;
            final /* synthetic */ InstabugUserEventLogger c;
            {
                void var1_1;
                this.c = var1_1;
                this.a = string2;
                this.b = userEventParamArray;
            }

            @Override
            public void run() {
                if (d.d().b((Object)"USER_EVENTS") == Feature.State.ENABLED) {
                    Object object = new UserEvent().setEventIdentifier(this.a).setDate(InstabugDateFormatter.getCurrentUTCTimeStampInMiliSeconds());
                    UserEventParam[] userEventParamArray = this.b;
                    int n2 = this.b.length;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        ((UserEvent)object).addParam(userEventParamArray[i2]);
                    }
                    if (this.c.userEvents.size() >= 1000) {
                        this.c.userEvents.remove(0);
                    }
                    a a2 = this;
                    a2.c.userEvents.add(object);
                    object = (Integer)a2.c.userEventsCount.get(this.a);
                    if (object != null) {
                        this.c.userEventsCount.put(this.a, (Integer)object + 1);
                    } else {
                        this.c.userEventsCount.put(this.a, 1);
                    }
                    InstabugUserEventLogger.access$200(this.c, e.j(), e.n() ^ true);
                    return;
                }
            }
        });
    }

    @VisibleForTesting
    int getLoggingEventCount(@NonNull String userEventIdentifier) {
        return com.instabug.library.logging.a.b(userEventIdentifier, e.i());
    }

    public List<UserEvent> getUserEvents() throws IllegalStateException {
        return this.userEvents;
    }

    /*
     * WARNING - void declaration
     */
    public List<UserEvent> getUserEvents(float percentage) throws IllegalStateException {
        void var1_2;
        int n2 = Math.round((float)(var1_2 * 1000.0f));
        if (this.userEvents.size() <= n2) {
            return this.userEvents;
        }
        InstabugUserEventLogger instabugUserEventLogger = this;
        int n3 = instabugUserEventLogger.userEvents.size() - n2;
        List<UserEvent> list = instabugUserEventLogger.userEvents;
        return list.subList(n3, list.size());
    }

    public void clearAll() throws IllegalStateException {
        this.userEvents.clear();
    }

    public void clearLoggingData() throws IllegalStateException {
        com.instabug.library.logging.a.a(e.i());
    }
}

