/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage.cache.db;

import android.annotation.SuppressLint;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.library.Instabug;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.diagnostics.IBGDiagnostics;
import com.instabug.library.util.InstabugSDKLogger;
import java.util.Arrays;

public class SQLiteDatabaseWrapper {
    @Nullable
    private SQLiteDatabase database;
    private final SQLiteOpenHelper databaseHelper;
    @Nullable
    private Boolean databaseTransactionsEnabled;

    /*
     * WARNING - void declaration
     */
    SQLiteDatabaseWrapper(SQLiteOpenHelper helper) {
        void var1_1;
        this.databaseHelper = var1_1;
    }

    private synchronized boolean isDatabaseTransactionsEnabled() {
        if (((SQLiteDatabaseWrapper)this).databaseTransactionsEnabled == null && Instabug.getApplicationContext() != null) {
            ((SQLiteDatabaseWrapper)this).databaseTransactionsEnabled = InstabugCore.isDatabaseTransactionDisabled() ^ true;
        }
        if ((this = ((SQLiteDatabaseWrapper)this).databaseTransactionsEnabled) != null) {
            return (Boolean)this;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void logOperationFailedWarning(String message) {
        void var1_1;
        SQLiteDatabaseWrapper this_ = this_.database;
        if (this_ == null) {
            InstabugSDKLogger.e("IBG-Core", "Attempted to do operation on an uninitialized database. Falling back silently");
            return;
        }
        if (!this_.isOpen()) {
            InstabugSDKLogger.e("IBG-Core", "Attempted to do operation on a closed database. Falling back silently");
            return;
        }
        InstabugSDKLogger.e("IBG-Core", (String)var1_1 + " ,Falling back silently");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void open() {
        Exception exception2;
        block7: {
            OutOfMemoryError outOfMemoryError2;
            block6: {
                block5: {
                    SQLiteDatabase sQLiteDatabase;
                    try {
                        sQLiteDatabase = this.database;
                        if (sQLiteDatabase == null) break block5;
                    }
                    catch (OutOfMemoryError outOfMemoryError2) {
                        break block6;
                    }
                    catch (Exception exception2) {
                        break block7;
                    }
                    if (sQLiteDatabase.isOpen()) {
                        return;
                    }
                }
                this.database = this.databaseHelper.getWritableDatabase();
                return;
            }
            InstabugSDKLogger.e("IBG-Core", "Error while opening the DB: " + outOfMemoryError2.getMessage(), outOfMemoryError2);
            IBGDiagnostics.reportNonFatal(outOfMemoryError2, "Error while opening the DB: " + outOfMemoryError2.getMessage());
            return;
        }
        InstabugSDKLogger.e("IBG-Core", "Error while opening the DB: " + exception2.getMessage(), exception2);
        IBGDiagnostics.reportNonFatal(exception2, "Error while opening the DB: " + exception2.getMessage());
    }

    public synchronized void close() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
    public void beginTransaction() {
        Exception exception2;
        block7: {
            OutOfMemoryError outOfMemoryError2;
            block6: {
                block5: {
                    SQLiteDatabase sQLiteDatabase;
                    try {
                        sQLiteDatabase = this.database;
                        if (sQLiteDatabase == null) break block5;
                    }
                    catch (OutOfMemoryError outOfMemoryError2) {
                        break block6;
                    }
                    catch (Exception exception2) {
                        break block7;
                    }
                    if (sQLiteDatabase.isOpen()) {
                        if (!this.isDatabaseTransactionsEnabled()) return;
                        this.database.beginTransaction();
                        return;
                    }
                }
                this.logOperationFailedWarning("DB transaction failed");
                return;
            }
            IBGDiagnostics.reportNonFatal(outOfMemoryError2, "DB transaction failed due to: " + outOfMemoryError2.getMessage());
            this.logOperationFailedWarning("\"DB transaction failed due to an Exception due to: " + outOfMemoryError2.getMessage());
            return;
        }
        IBGDiagnostics.reportNonFatal(exception2, "DB transaction failed due to: " + exception2.getMessage());
        this.logOperationFailedWarning("DB transaction failed due to:" + exception2.getMessage());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public long insert(@NonNull String table, @Nullable String nullColumnHack, @NonNull ContentValues values) {
        Exception exception2;
        block7: {
            OutOfMemoryError outOfMemoryError2;
            block6: {
                block5: {
                    SQLiteDatabase sQLiteDatabase;
                    try {
                        sQLiteDatabase = this.database;
                        if (sQLiteDatabase == null) break block5;
                    }
                    catch (OutOfMemoryError outOfMemoryError2) {
                        break block6;
                    }
                    catch (Exception exception2) {
                        break block7;
                    }
                    if (sQLiteDatabase.isOpen()) {
                        void var3_5;
                        void var2_4;
                        void var1_1;
                        return this.database.insert((String)var1_1, (String)var2_4, (ContentValues)var3_5);
                    }
                }
                this.logOperationFailedWarning("DB insertion failed");
                return -1L;
            }
            IBGDiagnostics.reportNonFatal(outOfMemoryError2, "DB insertion failed due to: " + outOfMemoryError2.getMessage() + Arrays.toString(outOfMemoryError2.getStackTrace()));
            this.logOperationFailedWarning("DB insertion failed due to: " + outOfMemoryError2.getMessage() + Arrays.toString(outOfMemoryError2.getStackTrace()));
            return -1L;
        }
        IBGDiagnostics.reportNonFatal(exception2, "DB insertion failed due to: " + exception2.getMessage() + Arrays.toString(exception2.getStackTrace()));
        this.logOperationFailedWarning("DB insertion failed due to: " + exception2.getMessage() + Arrays.toString(exception2.getStackTrace()));
        return -1L;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public long insertWithOnConflict(@NonNull String tableName, @Nullable String nullColumnHack, @NonNull ContentValues values) {
        Exception exception2;
        block7: {
            OutOfMemoryError outOfMemoryError2;
            block6: {
                block5: {
                    SQLiteDatabase sQLiteDatabase;
                    try {
                        sQLiteDatabase = this.database;
                        if (sQLiteDatabase == null) break block5;
                    }
                    catch (OutOfMemoryError outOfMemoryError2) {
                        break block6;
                    }
                    catch (Exception exception2) {
                        break block7;
                    }
                    if (sQLiteDatabase.isOpen()) {
                        void var3_5;
                        void var2_4;
                        void var1_1;
                        return this.database.insertWithOnConflict((String)var1_1, (String)var2_4, (ContentValues)var3_5, 4);
                    }
                }
                this.logOperationFailedWarning("DB insertion with on conflict failed");
                return -1L;
            }
            IBGDiagnostics.reportNonFatal(outOfMemoryError2, "DB insertion with on conflict failed: " + outOfMemoryError2.getMessage() + Arrays.toString(outOfMemoryError2.getStackTrace()));
            this.logOperationFailedWarning("DB insertion with on conflict failed due to: " + outOfMemoryError2.getMessage() + Arrays.toString(outOfMemoryError2.getStackTrace()));
            return -1L;
        }
        IBGDiagnostics.reportNonFatal(exception2, "DB insertion with on conflict failed: " + exception2.getMessage() + Arrays.toString(exception2.getStackTrace()));
        this.logOperationFailedWarning("DB insertion with on conflict failed due to: " + exception2.getMessage() + Arrays.toString(exception2.getStackTrace()));
        return -1L;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public long insertWithOnConflictReplace(@NonNull String tableName, @Nullable String nullColumnHack, @NonNull ContentValues values) {
        Exception exception2;
        block7: {
            OutOfMemoryError outOfMemoryError2;
            block6: {
                block5: {
                    SQLiteDatabase sQLiteDatabase;
                    try {
                        sQLiteDatabase = this.database;
                        if (sQLiteDatabase == null) break block5;
                    }
                    catch (OutOfMemoryError outOfMemoryError2) {
                        break block6;
                    }
                    catch (Exception exception2) {
                        break block7;
                    }
                    if (sQLiteDatabase.isOpen()) {
                        void var3_5;
                        void var2_4;
                        void var1_1;
                        return this.database.insertWithOnConflict((String)var1_1, (String)var2_4, (ContentValues)var3_5, 5);
                    }
                }
                this.logOperationFailedWarning("DB insertion with on conflict replace failed");
                return -1L;
            }
            IBGDiagnostics.reportNonFatal(outOfMemoryError2, "DB insertion with on conflict replace failed: " + outOfMemoryError2.getMessage() + Arrays.toString(outOfMemoryError2.getStackTrace()));
            this.logOperationFailedWarning("DB insertion with on conflict replace failed due to: " + outOfMemoryError2.getMessage() + Arrays.toString(outOfMemoryError2.getStackTrace()));
            return -1L;
        }
        IBGDiagnostics.reportNonFatal(exception2, "DB insertion with on conflict replace failed: " + exception2.getMessage() + Arrays.toString(exception2.getStackTrace()));
        this.logOperationFailedWarning("DB insertion with on conflict replace failed due to: " + exception2.getMessage() + Arrays.toString(exception2.getStackTrace()));
        return -1L;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
    public void execSQL(@NonNull String sql) {
        Exception exception2;
        block7: {
            OutOfMemoryError outOfMemoryError2;
            block6: {
                block5: {
                    SQLiteDatabase sQLiteDatabase;
                    try {
                        sQLiteDatabase = this.database;
                        if (sQLiteDatabase == null) break block5;
                    }
                    catch (OutOfMemoryError outOfMemoryError2) {
                        break block6;
                    }
                    catch (Exception exception2) {
                        break block7;
                    }
                    if (sQLiteDatabase.isOpen()) {
                        void var1_1;
                        this.database.execSQL((String)var1_1);
                        return;
                    }
                }
                this.logOperationFailedWarning("DB execution a sql failed");
                return;
            }
            IBGDiagnostics.reportNonFatal(outOfMemoryError2, "DB execution a sql failed: " + outOfMemoryError2.getMessage() + Arrays.toString(outOfMemoryError2.getStackTrace()));
            this.logOperationFailedWarning("DB execution a sql failed due to: " + outOfMemoryError2.getMessage() + Arrays.toString(outOfMemoryError2.getStackTrace()));
            return;
        }
        IBGDiagnostics.reportNonFatal(exception2, "DB execution a sql failed: " + exception2.getMessage() + Arrays.toString(exception2.getStackTrace()));
        this.logOperationFailedWarning("DB execution a sql failed due to: " + exception2.getMessage() + Arrays.toString(exception2.getStackTrace()));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
    public void execSQL(@NonNull String sql, @NonNull Object[] args) {
        Exception exception2;
        block7: {
            OutOfMemoryError outOfMemoryError2;
            block6: {
                block5: {
                    SQLiteDatabase sQLiteDatabase;
                    try {
                        sQLiteDatabase = this.database;
                        if (sQLiteDatabase == null) break block5;
                    }
                    catch (OutOfMemoryError outOfMemoryError2) {
                        break block6;
                    }
                    catch (Exception exception2) {
                        break block7;
                    }
                    if (sQLiteDatabase.isOpen()) {
                        void var2_4;
                        void var1_1;
                        this.database.execSQL((String)var1_1, (Object[])var2_4);
                        return;
                    }
                }
                this.logOperationFailedWarning("DB execution a sql failed");
                return;
            }
            IBGDiagnostics.reportNonFatal(outOfMemoryError2, "DB execution a sql failed: " + outOfMemoryError2.getMessage() + Arrays.toString(outOfMemoryError2.getStackTrace()));
            this.logOperationFailedWarning("DB execution a sql failed due to: " + outOfMemoryError2.getMessage() + Arrays.toString(outOfMemoryError2.getStackTrace()));
            return;
        }
        IBGDiagnostics.reportNonFatal(exception2, "DB execution a sql failed: " + exception2.getMessage() + Arrays.toString(exception2.getStackTrace()));
        this.logOperationFailedWarning("DB execution a sql failed due to: " + exception2.getMessage() + Arrays.toString(exception2.getStackTrace()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
    public void setTransactionSuccessful() {
        Exception exception2;
        block7: {
            OutOfMemoryError outOfMemoryError2;
            block6: {
                block5: {
                    SQLiteDatabase sQLiteDatabase;
                    try {
                        sQLiteDatabase = this.database;
                        if (sQLiteDatabase == null) break block5;
                    }
                    catch (OutOfMemoryError outOfMemoryError2) {
                        break block6;
                    }
                    catch (Exception exception2) {
                        break block7;
                    }
                    if (sQLiteDatabase.isOpen()) {
                        if (!this.isDatabaseTransactionsEnabled()) return;
                        this.database.setTransactionSuccessful();
                        return;
                    }
                }
                this.logOperationFailedWarning("DB transaction not successful");
                return;
            }
            IBGDiagnostics.reportNonFatal(outOfMemoryError2, "DB transaction not successful due to: " + outOfMemoryError2.getMessage());
            this.logOperationFailedWarning("DB transaction not successful due to: " + outOfMemoryError2.getMessage());
            return;
        }
        IBGDiagnostics.reportNonFatal(exception2, "DB transaction not successful due to: " + exception2.getMessage());
        this.logOperationFailedWarning("DB transaction not successful due to: " + exception2.getMessage());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
    public synchronized void endTransaction() {
        Exception exception2;
        block7: {
            OutOfMemoryError outOfMemoryError2;
            block6: {
                block5: {
                    SQLiteDatabase sQLiteDatabase;
                    try {
                        sQLiteDatabase = this.database;
                        if (sQLiteDatabase == null) break block5;
                    }
                    catch (OutOfMemoryError outOfMemoryError2) {
                        break block6;
                    }
                    catch (Exception exception2) {
                        break block7;
                    }
                    if (sQLiteDatabase.isOpen()) {
                        if (!this.isDatabaseTransactionsEnabled()) return;
                        this.database.endTransaction();
                        return;
                    }
                }
                this.logOperationFailedWarning("DB end transaction not successful");
                return;
            }
            IBGDiagnostics.reportNonFatal(outOfMemoryError2, "DB end transaction not successful due to: " + outOfMemoryError2.getMessage());
            this.logOperationFailedWarning("B end transaction not successful due to: " + outOfMemoryError2.getMessage());
            return;
        }
        IBGDiagnostics.reportNonFatal(exception2, "DB end transaction not successful due to: " + exception2.getMessage());
        this.logOperationFailedWarning("DB end transaction not successful due to: " + exception2.getMessage());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public Cursor rawQuery(@NonNull String sql, @Nullable String[] selectionArgs) {
        Exception exception2;
        block7: {
            OutOfMemoryError outOfMemoryError2;
            block6: {
                block5: {
                    SQLiteDatabase sQLiteDatabase;
                    try {
                        sQLiteDatabase = this.database;
                        if (sQLiteDatabase == null) break block5;
                    }
                    catch (OutOfMemoryError outOfMemoryError2) {
                        break block6;
                    }
                    catch (Exception exception2) {
                        break block7;
                    }
                    if (sQLiteDatabase.isOpen()) {
                        void var2_4;
                        void var1_1;
                        return this.database.rawQuery((String)var1_1, (String[])var2_4);
                    }
                }
                this.logOperationFailedWarning("DB raw query failed");
                return null;
            }
            IBGDiagnostics.reportNonFatal(outOfMemoryError2, "DB raw query failed: " + outOfMemoryError2.getMessage() + Arrays.toString(outOfMemoryError2.getStackTrace()));
            this.logOperationFailedWarning("DB raw query failed due to: " + outOfMemoryError2.getMessage() + Arrays.toString(outOfMemoryError2.getStackTrace()));
            return null;
        }
        IBGDiagnostics.reportNonFatal(exception2, "DB raw query failed: " + exception2.getMessage() + Arrays.toString(exception2.getStackTrace()));
        this.logOperationFailedWarning("DB raw query failed due to: " + exception2.getMessage() + Arrays.toString(exception2.getStackTrace()));
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public int delete(@NonNull String table, @Nullable String whereClause, @Nullable String[] whereArgs) {
        Exception exception2;
        block7: {
            OutOfMemoryError outOfMemoryError2;
            block6: {
                block5: {
                    SQLiteDatabase sQLiteDatabase;
                    try {
                        sQLiteDatabase = this.database;
                        if (sQLiteDatabase == null) break block5;
                    }
                    catch (OutOfMemoryError outOfMemoryError2) {
                        break block6;
                    }
                    catch (Exception exception2) {
                        break block7;
                    }
                    if (sQLiteDatabase.isOpen()) {
                        void var3_5;
                        void var2_4;
                        void var1_1;
                        return this.database.delete((String)var1_1, (String)var2_4, (String[])var3_5);
                    }
                }
                this.logOperationFailedWarning("DB deletion failed");
                return 0;
            }
            IBGDiagnostics.reportNonFatal(outOfMemoryError2, "DB raw query failed: " + outOfMemoryError2.getMessage() + Arrays.toString(outOfMemoryError2.getStackTrace()));
            this.logOperationFailedWarning("DB deletion failed: " + outOfMemoryError2.getMessage() + Arrays.toString(outOfMemoryError2.getStackTrace()));
            return 0;
        }
        IBGDiagnostics.reportNonFatal(exception2, "DB raw query failed: " + exception2.getMessage() + Arrays.toString(exception2.getStackTrace()));
        this.logOperationFailedWarning("DB deletion failed: " + exception2.getMessage() + Arrays.toString(exception2.getStackTrace()));
        return 0;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public int update(@NonNull String table, @NonNull ContentValues values, @Nullable String whereClause, @Nullable String[] whereArgs) {
        Exception exception2;
        block7: {
            OutOfMemoryError outOfMemoryError2;
            block6: {
                block5: {
                    SQLiteDatabase sQLiteDatabase;
                    try {
                        sQLiteDatabase = this.database;
                        if (sQLiteDatabase == null) break block5;
                    }
                    catch (OutOfMemoryError outOfMemoryError2) {
                        break block6;
                    }
                    catch (Exception exception2) {
                        break block7;
                    }
                    if (sQLiteDatabase.isOpen()) {
                        void var4_6;
                        void var3_5;
                        void var2_4;
                        void var1_1;
                        return this.database.update((String)var1_1, (ContentValues)var2_4, (String)var3_5, (String[])var4_6);
                    }
                }
                this.logOperationFailedWarning("DB update failed");
                return -1;
            }
            IBGDiagnostics.reportNonFatal(outOfMemoryError2, "DB update failed: " + outOfMemoryError2.getMessage() + Arrays.toString(outOfMemoryError2.getStackTrace()));
            this.logOperationFailedWarning("DB update failed: " + outOfMemoryError2.getMessage() + Arrays.toString(outOfMemoryError2.getStackTrace()));
            return -1;
        }
        IBGDiagnostics.reportNonFatal(exception2, "DB update failed: " + exception2.getMessage() + Arrays.toString(exception2.getStackTrace()));
        this.logOperationFailedWarning("DB update failed: " + exception2.getMessage() + Arrays.toString(exception2.getStackTrace()));
        return -1;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public Cursor query(String table, @Nullable String[] columns, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String groupBy, @Nullable String having, @Nullable String orderBy) {
        Exception exception2;
        block7: {
            OutOfMemoryError outOfMemoryError2;
            block6: {
                block5: {
                    SQLiteDatabase sQLiteDatabase;
                    try {
                        sQLiteDatabase = this.database;
                        if (sQLiteDatabase == null) break block5;
                    }
                    catch (OutOfMemoryError outOfMemoryError2) {
                        break block6;
                    }
                    catch (Exception exception2) {
                        break block7;
                    }
                    if (sQLiteDatabase.isOpen()) {
                        void var7_9;
                        void var6_8;
                        void var5_7;
                        void var4_6;
                        void var3_5;
                        void var2_4;
                        void var1_1;
                        return this.database.query((String)var1_1, (String[])var2_4, (String)var3_5, (String[])var4_6, (String)var5_7, (String)var6_8, (String)var7_9);
                    }
                }
                this.logOperationFailedWarning("DB query failed");
                return null;
            }
            IBGDiagnostics.reportNonFatal(outOfMemoryError2, "DB query failed: " + outOfMemoryError2.getMessage() + Arrays.toString(outOfMemoryError2.getStackTrace()));
            this.logOperationFailedWarning("DB query failed due to: " + outOfMemoryError2.getMessage() + Arrays.toString(outOfMemoryError2.getStackTrace()));
            return null;
        }
        IBGDiagnostics.reportNonFatal(exception2, "DB query failed: " + exception2.getMessage() + Arrays.toString(exception2.getStackTrace()));
        this.logOperationFailedWarning("DB query failed due to: " + exception2.getMessage() + Arrays.toString(exception2.getStackTrace()));
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public Cursor query(String table, @Nullable String[] columns, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String groupBy, @Nullable String having, @Nullable String orderBy, @Nullable String limit) {
        Exception exception2;
        block7: {
            OutOfMemoryError outOfMemoryError2;
            block6: {
                block5: {
                    SQLiteDatabase sQLiteDatabase;
                    try {
                        sQLiteDatabase = this.database;
                        if (sQLiteDatabase == null) break block5;
                    }
                    catch (OutOfMemoryError outOfMemoryError2) {
                        break block6;
                    }
                    catch (Exception exception2) {
                        break block7;
                    }
                    if (sQLiteDatabase.isOpen()) {
                        void var8_10;
                        void var7_9;
                        void var6_8;
                        void var5_7;
                        void var4_6;
                        void var3_5;
                        void var2_4;
                        void var1_1;
                        return this.database.query((String)var1_1, (String[])var2_4, (String)var3_5, (String[])var4_6, (String)var5_7, (String)var6_8, (String)var7_9, (String)var8_10);
                    }
                }
                this.logOperationFailedWarning("DB query failed");
                return null;
            }
            IBGDiagnostics.reportNonFatal(outOfMemoryError2, "DB query failed: " + outOfMemoryError2.getMessage() + Arrays.toString(outOfMemoryError2.getStackTrace()));
            this.logOperationFailedWarning("DB query failed due to: " + outOfMemoryError2.getMessage() + Arrays.toString(outOfMemoryError2.getStackTrace()));
            return null;
        }
        IBGDiagnostics.reportNonFatal(exception2, "DB query failed: " + exception2.getMessage() + Arrays.toString(exception2.getStackTrace()));
        this.logOperationFailedWarning("DB query failed due to: " + exception2.getMessage() + Arrays.toString(exception2.getStackTrace()));
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public long queryNumEntries(@NonNull String tableName) {
        Exception exception2;
        block7: {
            OutOfMemoryError outOfMemoryError2;
            block6: {
                block5: {
                    SQLiteDatabase sQLiteDatabase;
                    try {
                        sQLiteDatabase = this.database;
                        if (sQLiteDatabase == null) break block5;
                    }
                    catch (OutOfMemoryError outOfMemoryError2) {
                        break block6;
                    }
                    catch (Exception exception2) {
                        break block7;
                    }
                    if (sQLiteDatabase.isOpen()) {
                        void var1_1;
                        return DatabaseUtils.queryNumEntries((SQLiteDatabase)this.database, (String)var1_1);
                    }
                }
                this.logOperationFailedWarning("DB query num entries failed");
                return -1L;
            }
            IBGDiagnostics.reportNonFatal(outOfMemoryError2, "DB query num entries failed: " + outOfMemoryError2.getMessage() + Arrays.toString(outOfMemoryError2.getStackTrace()));
            this.logOperationFailedWarning("DB query num entries failed due to: " + outOfMemoryError2.getMessage() + Arrays.toString(outOfMemoryError2.getStackTrace()));
            return -1L;
        }
        IBGDiagnostics.reportNonFatal(exception2, "DB query num entries failed: " + exception2.getMessage() + Arrays.toString(exception2.getStackTrace()));
        this.logOperationFailedWarning("DB query num entries failed due to: " + exception2.getMessage() + Arrays.toString(exception2.getStackTrace()));
        return -1L;
    }

    @VisibleForTesting
    public void closeDB() {
        SQLiteOpenHelper sQLiteOpenHelper = this.databaseHelper;
        if (sQLiteOpenHelper != null) {
            sQLiteOpenHelper.close();
        }
        if ((sQLiteOpenHelper = this.database) != null) {
            sQLiteOpenHelper.close();
            this.database = null;
            return;
        }
    }

    public boolean deleteDatabase(Context context) {
        SQLiteDatabaseWrapper sQLiteDatabaseWrapper = this;
        sQLiteDatabaseWrapper.closeDB();
        return context.deleteDatabase(sQLiteDatabaseWrapper.databaseHelper.getDatabaseName());
    }
}

