/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.orchestrator;

import androidx.annotation.NonNull;
import com.instabug.library.internal.orchestrator.Action;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;

public final class ActionsOrchestrator {
    private final List<Action> sameThreadActions;
    private final List<Action> workerThreadActions;
    private final Executor backgroundExecutor;

    /*
     * WARNING - void declaration
     */
    private ActionsOrchestrator(Executor backgroundExecutor) {
        ArrayList arrayList;
        ArrayList arrayList2;
        void var1_1;
        ((ActionsOrchestrator)this_).backgroundExecutor = var1_1;
        Object this_ = arrayList2;
        arrayList2 = new ArrayList();
        v1.sameThreadActions = this_;
        this_ = arrayList;
        arrayList = new ArrayList();
        v1.workerThreadActions = this_;
    }

    public static ActionsOrchestrator obtainOrchestrator() {
        return new ActionsOrchestrator(PoolProvider.getInstance().getBackgroundExecutor());
    }

    public static ActionsOrchestrator obtainOrchestrator(@NonNull Executor workerThreadExecutor) {
        Executor executor;
        return new ActionsOrchestrator(executor);
    }

    private void orchestrateSameThreadActions() {
        Iterator<Action> iterator = this.sameThreadActions.iterator();
        while (iterator.hasNext()) {
            this.runAction(iterator.next());
        }
    }

    private void orchestrateWorkerThreadActions() {
        PoolProvider.postTask(this.backgroundExecutor, new Runnable(this){
            final /* synthetic */ ActionsOrchestrator a;
            {
                void var1_1;
                this.a = var1_1;
            }

            @Override
            public void run() {
                for (Action action : this.a.workerThreadActions) {
                    ActionsOrchestrator.access$100(this.a, action);
                }
            }
        });
    }

    private void runAction(Action action) {
        try {
            action.run();
            return;
        }
        catch (Exception exception) {
            InstabugSDKLogger.e("IBG-Core", "Error while running action: " + exception.getMessage(), exception);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$100(ActionsOrchestrator x02, Action x12) {
        void var1_1;
        x02.runAction((Action)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ActionsOrchestrator addSameThreadAction(@NonNull Action action) {
        void var1_1;
        ActionsOrchestrator actionsOrchestrator = this;
        actionsOrchestrator.sameThreadActions.add((Action)var1_1);
        return actionsOrchestrator;
    }

    /*
     * WARNING - void declaration
     */
    public ActionsOrchestrator addWorkerThreadAction(@NonNull Action action) {
        void var1_1;
        ActionsOrchestrator actionsOrchestrator = this;
        actionsOrchestrator.workerThreadActions.add((Action)var1_1);
        return actionsOrchestrator;
    }

    public void orchestrate() {
        ActionsOrchestrator actionsOrchestrator = this;
        actionsOrchestrator.orchestrateSameThreadActions();
        actionsOrchestrator.orchestrateWorkerThreadActions();
    }
}

