/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import androidx.annotation.Nullable;
import com.instabug.library.util.InstabugSDKLogger;

public class InstabugMediaProjectionIntent {
    @Nullable
    private static Intent mediaProjectionIntent;
    private static int staticResultCode;
    private static boolean isMediaProjectionIntentUsed = false;

    private InstabugMediaProjectionIntent() {
    }

    public static void setMediaProjectionIntent(@Nullable Intent mediaProjectionIntent) {
        InstabugMediaProjectionIntent.mediaProjectionIntent = mediaProjectionIntent;
        InstabugMediaProjectionIntent.setMediaProjectionIntentUsed(false);
    }

    @Nullable
    public static Intent getMediaProjectionIntent() {
        return mediaProjectionIntent;
    }

    public static void setMediaProjectionIntentUsed(boolean isMediaProjectionIntentUsed) {
        InstabugMediaProjectionIntent.isMediaProjectionIntentUsed = isMediaProjectionIntentUsed;
    }

    public static void release() {
        InstabugMediaProjectionIntent.setMediaProjectionIntentUsed(false);
        mediaProjectionIntent = null;
        staticResultCode = -1;
    }

    public static void setStaticResultCode(int staticResultCode) {
        InstabugMediaProjectionIntent.staticResultCode = staticResultCode;
    }

    public static int getStaticResultCode() {
        return staticResultCode;
    }

    public static boolean isMediaProjectionIntentReadyToUse() {
        return mediaProjectionIntent != null && (!isMediaProjectionIntentUsed || Build.VERSION.SDK_INT < 34);
    }

    public static boolean canStartMediaProjectionFGService(Context context) {
        Context context2;
        if (Build.VERSION.SDK_INT >= 34 && context2.checkSelfPermission("android.permission.FOREGROUND_SERVICE_MEDIA_PROJECTION") != 0) {
            InstabugSDKLogger.e("IBG-Core", "Can't found FOREGROUND_SERVICE_MEDIA_PROJECTION permission!");
            return false;
        }
        return true;
    }
}

