package com.instabug.library.util.overairversion

import com.instabug.library.internal.sharedpreferences.corePref

object OverAirSharedConstants {

    const val CODE_PUSH_LENGTH_LIMIT = 30
    const val EXPO_LENGTH_LIMIT = 36

    const val PREF_KEY_IB_OVER_AIR_VERSION = "ib_over_air_version"
    const val PREF_VALUE_NOT_SET = "IBG-OVER-AIR-VERSION-NOT-SET"

    const val PREF_KEY_IB_OVER_AIR_TYPE = "ib_over_air_type"
    const val PREF_TYPE_NOT_SET = 0

    const val CODE_PUSH_NOT_PROVIDED_ERROR =
        "Code push string is empty. All sessions and reports will be sent with the default app version."

    const val CODE_PUSH_LIMIT_EXCEEDED_ERROR =
        "Code push string exceeds the " + CODE_PUSH_LENGTH_LIMIT +
            " character limit. Extra trailing characters will be trimmed."

    const val WITH_CODE_PUSH_FORMAT = "%s+codepush:%s"

    const val EXPO_NOT_PROVIDED_ERROR =
        "Expo version string is empty. All sessions and reports will be sent with the default app version"

    const val EXPO_LENGTH_LIMIT_EXCEEDED_ERROR =
        "Expo version string exceeds the $EXPO_LENGTH_LIMIT character limit. Extra trailing characters will be trimmed."

    const val WITH_EXPO_FORMAT = "%s+expo:%s"

    /**
     * Checks if the provided Code Push version is valid or not.
     * @return true if the provided version is not null & not blank and false otherwise.
     */
    fun isValid(version: String?): Boolean = !version.isNullOrBlank()
    var storedType by corePref(PREF_KEY_IB_OVER_AIR_TYPE, PREF_TYPE_NOT_SET)
}

