package com.instabug.library.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Random;

public class MathUtils {

    public static int getPercentageOf(int number, int percentage) {
        return number * percentage / 100;
    }

    public static float getPercentageOf(float number, int percentage) {
        return number * percentage / 100;
    }

    public static long getPercentageOf(long number, int percentage) {
        return number * percentage / 100;
    }

    public static double getPercentageOf(double number, int percentage) {
        return number * percentage / 100;
    }

    public static double generateRandomNumber(double ceiling) {
        Random random = new Random();
        return round(random.nextDouble() * ceiling, 2) ;
    }

    public static double round(double value, int places) {
        if (places < 0) throw new IllegalArgumentException();

        BigDecimal bd = BigDecimal.valueOf(value);
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

}
