package com.instabug.library.ui.custom;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;

import androidx.viewpager.widget.ViewPager;

/**
 * Created by mohamedzakaria on 5/24/17.
 */

public class InstabugViewPager extends ViewPager {

    private boolean swipeable;
    private boolean autoHeight = false;

    public InstabugViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.swipeable = true;
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        if (this.swipeable) {
            return super.onTouchEvent(event);
        }
        return false;
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent event) {
        if (this.swipeable) {
            return super.onInterceptTouchEvent(event);
        }
        return false;
    }

    /**
     * method to enable or disable {@link InstabugViewPager} swipe
     *
     * @param swipeEnabled
     */
    public void setSwipeable(boolean swipeEnabled) {
        this.swipeable = swipeEnabled;
    }

    public void scrollForward(boolean smoothScroll) {
        if (getAdapter() != null && getAdapter().getCount() - 1 > getCurrentItem()) {
            setCurrentItem(getCurrentItem() + 1, smoothScroll);
        }
    }

    public void scrollBackward(boolean smoothScroll) {
        scrollBackwardWithOffset(smoothScroll, 1);
    }

    public void scrollBackwardWithOffset(boolean smoothScroll, int offset) {
        if (getAdapter() != null && getCurrentItem() > 0) {
            setCurrentItem(getCurrentItem() - offset, smoothScroll);
        }
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (autoHeight) {
            int height = 0;
            for (int i = 0; i < getChildCount(); i++) {
                View child = getChildAt(i);
                child.measure(widthMeasureSpec, MeasureSpec.makeMeasureSpec(0, MeasureSpec.UNSPECIFIED));
                int h = child.getMeasuredHeight();
                if (h > height) height = h;
            }

            if (height != 0) {
                heightMeasureSpec = MeasureSpec.makeMeasureSpec(height, MeasureSpec.EXACTLY);
            }
        }

        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public void setAutoHeight(boolean autoHeight) {
        this.autoHeight = autoHeight;
    }
}