package com.instabug.library.transform;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Used to mark classes that are used in Code transformations thus may no have usage in the code base,
 * Modifications on such classes would not affect the compilation of the SDK but will affect
 * compilation of apps applying transformation dependant on these classes
 */
@Retention(RetentionPolicy.CLASS)
@Target(ElementType.TYPE)
public @interface TransformationClass {
}
