package com.instabug.library.tokenmapping

import com.instabug.library.IBGFeature
import com.instabug.library.InstabugFeaturesManager
import com.instabug.library.internal.servicelocator.CoreServiceLocator
import com.instabug.library.internal.sharedpreferences.corePref
import com.instabug.library.settings.SettingsManager
import org.json.JSONObject

interface TokenMappingConfigsHandler {
    fun handle(featuresRequest: JSONObject?)
}

interface TokenMappingConfigurations {
    var isTokenMappingEnabled: Boolean
    var mappedAppToken: String?
    val availableAppToken: String?
}

class TokenMappingConfigsHandlerImpl : TokenMappingConfigsHandler {

    override fun handle(featuresRequest: JSONObject?) {
        val isSdkEnabled: Boolean =
            InstabugFeaturesManager.getInstance().isFeatureAvailable(IBGFeature.INSTABUG)
        val isTokenMappingEnabled: Boolean =
            featuresRequest?.optBoolean("token_mapping", false) ?: false
        val currentTokenMappingEnabled: Boolean =
            TokenMappingServiceLocator.getTokenMappingConfigs().isTokenMappingEnabled

        if (isSdkEnabled && isTokenMappingEnabled && !currentTokenMappingEnabled) {
            TokenMappingServiceLocator.getTokenMappingConfigs().isTokenMappingEnabled = true
            TokenMappingServiceLocator.getTokenMappingSync().start()
        } else if (!isTokenMappingEnabled && currentTokenMappingEnabled) {
            TokenMappingServiceLocator.getTokenMappingConfigs().isTokenMappingEnabled = false
            TokenMappingServiceLocator.getTokenMappingConfigs().mappedAppToken = ""
        }
    }

}

object TokenMappingConfigurationsImpl : TokenMappingConfigurations {

    private const val TOKEN_MAPPING_ENABLED = "ib_is_token_mapping_enabled"
    private const val MAPPED_APP_TOKEN = "ib_mapped_app_token"

    override var isTokenMappingEnabled: Boolean by corePref(TOKEN_MAPPING_ENABLED, false)

    override var mappedAppToken: String? by corePref(MAPPED_APP_TOKEN, "")

    override val availableAppToken: String?
        get() = takeIf { isTokenMappingEnabled && mappedAppToken?.isNotEmpty() == true }?.let { mappedAppToken }
            ?: SettingsManager.getInstance().appToken

}