package com.instabug.library.session;

import androidx.annotation.IntRange;
import androidx.annotation.NonNull;

import com.instabug.library.model.session.CoreSession;
import com.instabug.library.model.session.SessionsBatchDTO;

import java.util.List;

public interface SessionBatcher {

    /**
     * Returns an immutable list of {@link SessionsBatchDTO} containing only the specified session.
     *
     * @param session the session to be batched
     * @return list of batched sessions containing only one session
     */
    @NonNull
    List<SessionsBatchDTO> batch(@NonNull CoreSession session);

    /**
     * Returns an immutable list of {@link SessionsBatchDTO} containing the specified sessions.
     *
     * @param sessions the sessions to be batched
     * @return list containing all sessions as one batch
     */
    @NonNull
    List<SessionsBatchDTO> batch(@NonNull List<CoreSession> sessions);

    /**
     * Converts a group of sessions into smaller batches bounded by the {@code maxPerBatch}
     *
     * @param sessions    the sessions to be batched
     * @param maxPerBatch the maximum number of sessions per batch
     * @return list containing all sessions batches
     */
    @NonNull
    List<SessionsBatchDTO> batch(@NonNull List<CoreSession> sessions, @IntRange(from = 1) int maxPerBatch);
}
