package com.instabug.library.internal.video

import android.Manifest
import android.content.Context
import android.content.pm.PackageManager
import com.instabug.library.BuildFieldsProvider

object MediaProjectionHelper {

    fun isMediaProjectionServiceAvailable(context: Context) =
        if (!BuildFieldsProvider.isAtleastVersion34OrAbove) true else isPermissionInManifest(
            context,
            Manifest.permission.FOREGROUND_SERVICE_MEDIA_PROJECTION
        )


    private fun isPermissionInManifest(context: Context, permission: String): Boolean =
        getPermissionsInManifest(context)?.any { existingPermission ->
            existingPermission == permission
        } ?: false


    private fun getPermissionsInManifest(context: Context) =
        context.packageManager?.getPackageInfo(
            context.packageName,
            PackageManager.GET_PERMISSIONS
        )?.requestedPermissions


}