package com.instabug.library.internal.storage.cache.dbv2.migration

import android.database.sqlite.SQLiteDatabase
import com.instabug.library.diagnostics.diagnostics_db.NonFatalEntry
import com.instabug.library.diagnostics.diagnostics_db.NonFatalOccurrenceEntry
import com.instabug.library.diagnostics.nonfatals.cache.NonFatalCacheManager
import com.instabug.library.internal.storage.DiskUtils
import com.instabug.library.internal.storage.cache.dbv2.IBGDbContract
import com.instabug.library.internal.storage.cache.dbv2.IBGEncryptedDbVersions

class DBMigrationV2(override val db: SQLiteDatabase) : BaseDBMigrationImpl(db) {
    override val previous: BaseDbMigration?
        get() = null
    override val version: Int
        get() = IBGEncryptedDbVersions.DB_V2

    override fun execute() = runLogic {
        DiskUtils.deleteStateFiles(NonFatalCacheManager.NON_FATAL_STATE)
        db.execSQL(NonFatalEntry.DROP_TABLE)
        db.execSQL(NonFatalOccurrenceEntry.DROP_TABLE)
        db.execSQL(NonFatalEntry.CREATE_TABLE)
        db.execSQL(NonFatalOccurrenceEntry.CREATE_TABLE)
    }
}