package com.instabug.library.internal.servicelocator;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;

/**
 * The InitialContext is the starting point in the lookup and creation process for the {@link ServiceLocator}.
 * If a clients requests a  certain object for the first time, the {@link ServiceLocator} expects
 * it to be provided by the InitialContext. If it's not provided it falls back to {@code null}
 */
@RestrictTo(RestrictTo.Scope.LIBRARY_GROUP)
public interface InitialContext {

    /**
     * Returns the instance to which the specified service type is mapped to,
     * or {@code null} if no mapping for the serviceType was found.
     *
     * @param serviceType the class type of the requested service
     * @return the service instance if present or {@code null} otherwise
     */
    @Nullable
    @RestrictTo(RestrictTo.Scope.LIBRARY_GROUP)
    <T> T lookup(@NonNull Class<T> serviceType);
}
