package com.instabug.library.diagnostics.nonfatals

import com.instabug.library.Feature
import com.instabug.library.IBGFeature
import com.instabug.library.diagnostics.DiagnosticsConstants.ENABLED
import com.instabug.library.diagnostics.DiagnosticsConstants.NON_FATALS
import com.instabug.library.diagnostics.configuration.ConfigurationChangedHandler
import com.instabug.library.internal.resolver.NonFatalSettingResolver
import com.instabug.library.percentagefeatures.IBGPercentageFlagsResolver
import org.json.JSONObject

class NonFatalsConfigurationChangedHandler(
    private val settingsResolver: NonFatalSettingResolver = NonFatalSettingResolver.getInstance()
) : ConfigurationChangedHandler {
    override fun onConfigurationChanged(json: JSONObject?) {
        json?.optJSONObject(NON_FATALS)?.run {
            IBGPercentageFlagsResolver.resolve(
                IBGFeature.NON_FATAL_ERRORS,
                optDouble(ENABLED, 0.0)
            )
            settingsResolver.setNonFatalSettings(this)
        }
    }
}