package com.instabug.library.datahub

import com.instabug.library.logscollection.LogReceiver
import com.instabug.library.util.extenstions.runOrLogAndReport
import org.json.JSONObject

interface DataHubLog {
    val dataHubRep: JSONObject?
}

interface HubDataReceiver<T : DataHubLog> : LogReceiver<T>

class SimpleHubDataReceiver<T : DataHubLog>(
    private val logStore: HubDataStore<T>
) : HubDataReceiver<T> {
    override fun invoke(log: T) {
        runCatching { logStore.store(log) }
            .runOrLogAndReport("Error while delegating data to store.")
    }
}