package com.instabug.library.coreSDKChecks

import com.instabug.library.core.eventbus.coreeventbus.IBGCoreEventPublisher
import com.instabug.library.core.eventbus.coreeventbus.IBGSdkCoreEvent
import com.instabug.library.settings.SettingsManager

class CurrentAppTokenChangeHandler(private val settingsManager: SettingsManager?) {
    internal fun setCurrentToken() {
        settingsManager?.run {
            if (savedAppToken.isNullOrBlank()) savedAppToken = appToken
            else if (savedAppToken != appToken) onAppTokenChanged()
        }
    }

    private fun onAppTokenChanged() {
        settingsManager?.run { savedAppToken = appToken }
        IBGCoreEventPublisher.post(IBGSdkCoreEvent.AppTokenChanged)
    }
}