package com.instabug.library;

import static com.instabug.library.MaskingType.LABELS;
import static com.instabug.library.MaskingType.MASK_NOTHING;
import static com.instabug.library.MaskingType.MEDIA;
import static com.instabug.library.MaskingType.TEXT_INPUTS;

import androidx.annotation.IntDef;

import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.Retention;

@IntDef(value = {MASK_NOTHING, TEXT_INPUTS, LABELS, MEDIA})
@Retention(AnnotationRetention.SOURCE)
public @interface MaskingType {

    /**
     * used to Allow everything in the Repro-steps screenshots
     */
    int MASK_NOTHING = 0;
    /**
     * used to mask all text input in the Repro-steps screenshots
     */
    int TEXT_INPUTS = 1;
    /**
     * used to mask all labels in the Repro-steps screenshots
     */
    int LABELS = 2;
    /**
     * used to mask all media in the Repro-steps screenshots
     */
    int MEDIA = 3;
}
