/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.webkit.URLUtil;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.instabug.library.Instabug;
import com.instabug.library.apichecker.ReturnableRunnable;
import com.instabug.library.diagnostics.IBGDiagnostics;
import com.instabug.library.encryption.EncryptionManager;
import com.instabug.library.internal.storage.DiskUtils;
import com.instabug.library.internal.storage.ProcessedBytes;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class FileUtils {
    private static final int NOT_FOUND = -1;
    private static final char EXTENSION_SEPARATOR = '.';
    private static final char UNIX_SEPARATOR = '/';
    public static final String FLAG_ENCRYPTED = "_e";
    private static final int NUMBER_BYTES_TO_PROCESS = 256;
    private static final int IV_LENGTH = Build.VERSION.SDK_INT > 19 ? 12 : 16;

    public static int getFileType(@NonNull File file) {
        Object object;
        if (file.isDirectory()) {
            return 2;
        }
        if (FileUtils.getIndexOfExtension((String)(object = ((File)object).getAbsolutePath())) == -1) {
            return -1;
        }
        return FileUtils.getTypeFromExtension((String)object);
    }

    public static Intent getFileViewerIntent(@NonNull String pathOrUrl) {
        String string2;
        if (URLUtil.isNetworkUrl((String)pathOrUrl)) {
            return new Intent("android.intent.action.VIEW", Uri.parse((String)string2));
        }
        return FileUtils.appropriateIntent(Uri.fromFile((File)new File(string2)), FileUtils.getExtension(string2));
    }

    public static String getExtension(@NonNull File file) {
        return FileUtils.getExtension(file.getAbsolutePath());
    }

    public static String getExtension(@NonNull String absolutePath) {
        String string2;
        int n2 = FileUtils.getIndexOfExtension(absolutePath);
        if (n2 == -1) {
            return "";
        }
        return string2.substring(n2 + 1);
    }

    public static boolean isVideoFile(@NonNull File file) {
        File file2;
        if (!file.isFile()) {
            return false;
        }
        return FileUtils.isVideoExtension(FileUtils.getExtension(file2));
    }

    public static boolean isImageFile(@NonNull File file) {
        File file2;
        if (!file.isFile()) {
            return false;
        }
        return FileUtils.isImageExtension(FileUtils.getExtension(file2));
    }

    public static boolean isTextFile(@NonNull File file) {
        File file2;
        if (!file.isFile()) {
            return false;
        }
        return FileUtils.isTextExtension(FileUtils.getExtension(file2.getAbsolutePath()));
    }

    public static boolean isCacheFile(@NonNull File file) {
        File file2;
        if (!file.isFile()) {
            return false;
        }
        return FileUtils.isCacheExtension(FileUtils.getExtension(file2.getAbsolutePath()));
    }

    public static boolean isVideoExtension(@NonNull String extension) {
        String string2;
        return extension.equalsIgnoreCase("mp4") || string2.equalsIgnoreCase("avi") || string2.equalsIgnoreCase("mpg") || string2.equalsIgnoreCase("3gp") || string2.equalsIgnoreCase("3gpp") || string2.equalsIgnoreCase("ts") || string2.equalsIgnoreCase("AAC") || string2.equalsIgnoreCase("webm") || string2.equalsIgnoreCase("mkv");
        {
        }
    }

    public static boolean isImageExtension(@NonNull String extension) {
        String string2;
        return extension.equalsIgnoreCase("jpeg") || string2.equalsIgnoreCase("gif") || string2.equalsIgnoreCase("png") || string2.equalsIgnoreCase("bmp") || string2.equalsIgnoreCase("jpg") || string2.equalsIgnoreCase("webp");
        {
        }
    }

    private static boolean isTextExtension(@NonNull String extension) {
        return extension.equalsIgnoreCase("txt");
    }

    private static boolean isCacheExtension(@NonNull String extension) {
        return extension.equalsIgnoreCase("cache");
    }

    public static void sortByLastModifiedAsc(@NonNull List<File> files) {
        Comparator comparator;
        List<File> list;
        try {
            list = files;
        }
        catch (Exception exception) {
            InstabugSDKLogger.e("IBG-Core", "Exception " + exception.getMessage() + " while sorting list");
            return;
        }
        Comparator comparator2 = comparator;
        comparator = new Comparator(){

            /*
             * WARNING - void declaration
             */
            public int a(File f12, File f2) {
                void var2_2;
                return Double.compare(f12.lastModified(), var2_2.lastModified());
            }
        };
        Collections.sort(list, comparator2);
    }

    public static long getSize(@NonNull File file) {
        File[] fileArray;
        if (!file.exists()) {
            return 0L;
        }
        long l2 = fileArray.length();
        if (fileArray.isDirectory() && (fileArray = fileArray.listFiles()) != null) {
            int n2 = fileArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                l2 += FileUtils.getSize(fileArray[i2]);
            }
            return l2;
        }
        return l2;
    }

    private static int getTypeFromExtension(String absolutePath) {
        String string2 = FileUtils.getExtension(absolutePath);
        if (FileUtils.isVideoExtension(string2)) {
            return 0;
        }
        if (FileUtils.isImageExtension(string2)) {
            return 1;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private static Intent appropriateIntent(Uri uri, String extension) {
        Uri uri2;
        void var1_1;
        Intent intent;
        Intent intent2 = intent;
        intent = new Intent("android.intent.action.VIEW");
        if (!var1_1.equalsIgnoreCase("doc") && !var1_1.equalsIgnoreCase("docx")) {
            if (var1_1.equalsIgnoreCase("pdf")) {
                intent2.setDataAndType(uri2, "application/pdf");
            } else if (!var1_1.equalsIgnoreCase("ppt") && !var1_1.equalsIgnoreCase("pptx")) {
                if (!var1_1.equalsIgnoreCase("xls") && !var1_1.equalsIgnoreCase("xlsx")) {
                    if (!var1_1.equalsIgnoreCase("zip") && !var1_1.equalsIgnoreCase("rar")) {
                        if (var1_1.equalsIgnoreCase("rtf")) {
                            intent2.setDataAndType(uri2, "application/rtf");
                        } else if (!var1_1.equalsIgnoreCase("wav") && !var1_1.equalsIgnoreCase("mp3")) {
                            if (var1_1.equalsIgnoreCase("gif")) {
                                intent2.setDataAndType(uri2, "image/gif");
                            } else if (!(var1_1.equalsIgnoreCase("jpg") || var1_1.equalsIgnoreCase("jpeg") || var1_1.equalsIgnoreCase("png"))) {
                                if (var1_1.equalsIgnoreCase("txt")) {
                                    intent2.setDataAndType(uri2, "text/plain");
                                } else if (!(var1_1.equalsIgnoreCase("3gp") || var1_1.equalsIgnoreCase("mpg") || var1_1.equalsIgnoreCase("mpeg") || var1_1.equalsIgnoreCase("mpe") || var1_1.equalsIgnoreCase("mp4") || var1_1.equalsIgnoreCase("avi"))) {
                                    intent2.setDataAndType(uri2, "*/*");
                                } else {
                                    intent2.setDataAndType(uri2, "video/*");
                                }
                            } else {
                                intent2.setDataAndType(uri2, "image/jpeg");
                            }
                        } else {
                            intent2.setDataAndType(uri2, "audio/x-wav");
                        }
                    } else {
                        intent2.setDataAndType(uri2, "application/x-wav");
                    }
                } else {
                    intent2.setDataAndType(uri2, "application/vnd.ms-excel");
                }
            } else {
                intent2.setDataAndType(uri2, "application/vnd.ms-powerpoint");
            }
        } else {
            intent2.setDataAndType(uri2, "application/msword");
        }
        Intent intent3 = intent2;
        intent3.addFlags(0x10000000);
        return intent3;
    }

    @Nullable
    public static File getFile(String path) {
        String string2;
        File file;
        File file2 = file;
        if (new File(string2).exists()) {
            return file2;
        }
        return null;
    }

    public static boolean isFileRelatedToBugOrCrashReport(String filePath) {
        String string2;
        return filePath.contains("vusf") || string2.contains("view-hierarchy-images") || string2.contains("bug_") && string2.endsWith("_.jpg") || string2.contains("view_hierarchy_attachment_") && string2.endsWith(".zip") || string2.contains("usersteps_") && string2.endsWith(".zip");
        {
        }
    }

    public static int getIndexOfExtension(String filename) {
        String string2 = filename;
        int n2 = string2.lastIndexOf(46);
        if (string2.lastIndexOf(47) > n2) {
            return -1;
        }
        return n2;
    }

    public static boolean isEncryptedFile(String filePath) {
        Boolean bl;
        bl = (Boolean)PoolProvider.getFilesEncryptionExecutor().executeAndGet(new ReturnableRunnable((String)((Object)bl)){
            final /* synthetic */ String a;
            {
                this.a = string2;
            }

            public Boolean run() {
                b b2 = this;
                int n2 = FileUtils.getIndexOfExtension(b2.a);
                return b2.a.substring(0, n2).endsWith(FileUtils.FLAG_ENCRYPTED);
            }
        });
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public static String getPathWithEncryptedFlag(String path) {
        int n2 = FileUtils.getIndexOfExtension(path);
        if (n2 != -1) {
            String string2;
            String string3 = string2;
            string2 = string2.substring(0, n2);
            String string4 = string3.substring(n2);
            Object[] objectArray = new Object[3];
            Object[] objectArray2 = objectArray;
            objectArray[0] = string2;
            objectArray[1] = FLAG_ENCRYPTED;
            objectArray[2] = string4;
            return String.format("%s%s%s", objectArray2);
        }
        return "";
    }

    public static String getPathWithDecryptedFlag(String path) {
        return path.replace(FLAG_ENCRYPTED, "");
    }

    public static boolean isReproStepFile(String filePath) {
        String string2;
        return (filePath.contains("step") || string2.contains("icon")) && string2.endsWith(".png") && !string2.contains("usersteps_") && !string2.endsWith(".zip");
    }

    public static boolean encryptFile(@NonNull String path) throws UnsatisfiedLinkError {
        Boolean bl;
        bl = (Boolean)PoolProvider.getFilesEncryptionExecutor().executeAndGet(new ReturnableRunnable((String)((Object)bl)){
            final /* synthetic */ String a;
            {
                this.a = string2;
            }

            public Boolean run() {
                File file;
                File file2 = file;
                file = new File(this.a);
                boolean bl = FileUtils.access$000(1, file2);
                if (bl && (FileUtils.isReproStepFile(this.a) || FileUtils.isInternalAttachmentFile(this.a)) && !((String)(this = FileUtils.getPathWithEncryptedFlag(this.a))).equals("")) {
                    File file3;
                    File file4 = file2;
                    file2 = file3;
                    file3 = new File((String)this);
                    file4.renameTo(file2);
                }
                return bl;
            }
        });
        if (bl != null) {
            return bl;
        }
        return false;
    }

    private static boolean isInternalAttachmentFile(@NonNull String path) {
        return path.contains("internal-attachments");
    }

    public static boolean decryptFile(@NonNull String filePath) throws UnsatisfiedLinkError {
        Boolean bl;
        bl = (Boolean)PoolProvider.getFilesEncryptionExecutor().executeAndGet(new ReturnableRunnable((String)((Object)bl)){
            final /* synthetic */ String a;
            {
                this.a = string2;
            }

            public Boolean run() {
                File file;
                File file2 = file;
                file = new File(string2.a);
                boolean bl = FileUtils.access$000(2, file2);
                if (bl && (FileUtils.isReproStepFile(string2.a) || FileUtils.isInternalAttachmentFile(string2.a))) {
                    String string2 = FileUtils.getPathWithDecryptedFlag(string2.a);
                    file2.renameTo(new File(string2));
                }
                return bl;
            }
        });
        if (bl != null) {
            return bl;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private static boolean fileProcessor(int cipherMode, File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 7[TRYBLOCK] [23, 22, 21 : 137->141)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static ProcessedBytes decryptOnTheFly(String filePath) throws UnsatisfiedLinkError {
        String string2;
        return FileUtils.fileDecryptionOnTheFlyProcessor(new File(string2));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ProcessedBytes fileDecryptionOnTheFlyProcessor(File file) {
        block25: {
            block27: {
                block26: {
                    var1_4 = null;
                    var2_11 = v0;
                    v0 = new RandomAccessFile(var0, "rws");
                    var1_5 = 256;
                    ** try [egrp 2[TRYBLOCK] [8, 7, 6 : 19->22)] { 
lbl7:
                    // 1 sources

                    ** GOTO lbl25
lbl-1000:
                    // 1 sources

                    {
                        catch (Throwable var0_1) {
                            var1_4 = var2_11;
                            break block25;
                        }
lbl11:
                        // 1 sources

                        catch (OutOfMemoryError var1_6) {
                            ** GOTO lbl-1000
                        }
lbl13:
                        // 1 sources

                        catch (Exception var1_7) {
                            ** GOTO lbl-1000
                        }
                        catch (Throwable var0_2) {
                            break block25;
                        }
                        catch (OutOfMemoryError var2_12) {
                            var2_11 = var1_4;
                            var1_4 = var2_12;
                            ** GOTO lbl-1000
                        }
                        catch (Exception var2_13) {
                            var2_11 = var1_4;
                            var1_4 = var2_13;
                            ** GOTO lbl-1000
                        }
lbl25:
                        // 1 sources

                        var3_14 = FileUtils.IV_LENGTH;
                        var1_5 = var3_14 + var1_5;
                        var4_17 = new byte[var1_5];
                        if (v0.length() > (long)(var3_14 + 256)) {
                            v1 = var2_11;
                            v1.seek(v1.length() - (long)(var3_14 + 256));
                        }
                        v2 = var2_11;
                        v3 = var4_17;
                        var2_11.read(var4_17, 0, var1_5);
                    }
                    {
                        var1_8 = EncryptionManager.decrypt(v3);
                        if (v2.length() <= (long)(var3_14 + 256)) break block26;
                        v4 = var2_11;
                        {
                            v4.seek(v4.length() - (long)(var3_14 + 256));
                        }
                    }
                }
                v5 = var0;
                var1_9 = 0;
                {
                    var2_11.write(var1_8, var1_9, var1_8.length);
                    var1_10 = new byte[(int)v5.length()];
                }
                {
                    FileUtils.read(v5, var1_10);
                    if (!FileUtils.isReproStepFile(v5.getPath())) break block27;
                    v6 = var0;
                    var3_15 = FileUtils.getPathWithDecryptedFlag(v6.getPath());
                    v6.renameTo(new File(var3_15));
                }
            }
            var3_16 = v7;
            {
                v8 = var2_11;
                var3_16(var1_10, true);
            }
            try {
                v8.close();
                return v7;
            }
            catch (IOException v9) {
                v9.printStackTrace();
                return var3_16;
            }
lbl-1000:
            // 4 sources

            {
                InstabugSDKLogger.e("IBG-Core", "Error: " + var1_4 + " occurred while decrypting file in path: " + var0.getPath());
                IBGDiagnostics.reportNonFatal((Throwable)var1_4, "Error: " + var1_4 + " occurred while decrypting file in path: " + var0.getPath());
                if (var2_11 == null) return new ProcessedBytes(new byte[0], false);
            }
            try {
                var2_11.close();
                return new ProcessedBytes(new byte[0], false);
            }
            catch (IOException v10) {
                v10.printStackTrace();
            }
            return new ProcessedBytes(new byte[0], false);
        }
        if (var1_4 == null) throw var0_3;
        try {
            var1_4.close();
            throw var0_3;
        }
        catch (IOException v11) {
            v11.printStackTrace();
        }
        throw var0_3;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void read(File inputFile, byte[] outputBytes) throws IOException {
        void var0_3;
        FileInputStream fileInputStream;
        block6: {
            FileInputStream fileInputStream2;
            fileInputStream = null;
            FileInputStream fileInputStream3 = fileInputStream2;
            try {
                File file;
                fileInputStream2 = new FileInputStream(file);
            }
            catch (Throwable throwable) {
                // empty catch block
                break block6;
            }
            try {
                void var1_4;
                fileInputStream2.read((byte[])var1_4);
            }
            catch (Throwable throwable) {
                fileInputStream = fileInputStream3;
                break block6;
            }
            fileInputStream2.close();
            return;
        }
        if (fileInputStream != null) {
            fileInputStream.close();
        }
        throw var0_3;
    }

    @WorkerThread
    @NonNull
    public static synchronized List<File> getStateFiles(String prefix) {
        ArrayList<File> arrayList;
        ArrayList<File> arrayList2 = arrayList;
        arrayList = new ArrayList<File>();
        Object object = Instabug.getApplicationContext();
        if (object != null) {
            File[] fileArray;
            object = object.getFilesDir().getParentFile();
            fileArray = (arg_0, arg_1) -> FileUtils.lambda$getStateFiles$0((String)fileArray, arg_0, arg_1);
            if (object != null && (fileArray = ((File)object).listFiles((FilenameFilter)fileArray)) != null) {
                ArrayList<File> arrayList3 = arrayList2;
                arrayList3.addAll(Arrays.asList(fileArray));
                return arrayList3;
            }
        }
        return arrayList2;
    }

    @Nullable
    public static String getFileName(@NonNull String path) {
        return Uri.parse((String)path).getLastPathSegment();
    }

    public static void deleteDirectory(@Nullable File file) {
        if (file != null) {
            File[] fileArray;
            File file2;
            if (file2.isDirectory() && (fileArray = file2.listFiles()) != null) {
                int n2 = fileArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    FileUtils.deleteDirectory(fileArray[i2]);
                }
            }
            file2.delete();
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static String copyAndDeleteOriginalFile(@NonNull Context context, @Nullable String originalFilePath, @Nullable String newFileDirectory) {
        Context context2;
        void var1_1;
        File file;
        block9: {
            File file2;
            block8: {
                File file3;
                if (originalFilePath == null) return null;
                if (file2 == null) {
                    return null;
                }
                file = file3;
                try {
                    file2 = new File((String)((Object)file2) + Uri.parse((String)var1_1).getLastPathSegment()).getParentFile();
                    if (file2 != null) break block8;
                    return var1_1;
                }
                catch (IOException iOException) {}
            }
            if (file2.exists()) break block9;
            file2.mkdirs();
        }
        File file4 = file;
        void v3 = var1_1;
        Context context3 = context2;
        file.createNewFile();
        DiskUtils.copyFromUriIntoFile(context3, Uri.fromFile((File)new File((String)var1_1)), file);
        DiskUtils.deleteFile((String)v3);
        return file4.getAbsolutePath();
        InstabugSDKLogger.w("IBG-Core", "Something went wrong while copying the file");
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ boolean lambda$getStateFiles$0(String prefix, File dir, String name) {
        void var2_2;
        String string2;
        return name.startsWith(string2) && var2_2.endsWith(".txt");
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$000(int x02, File x12) {
        void var1_1;
        return FileUtils.fileProcessor(x02, (File)var1_1);
    }
}

