/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.screenshot;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ImageView;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import androidx.fragment.app.DialogFragment;
import com.google.android.material.bottomsheet.BottomSheetDialogFragment;
import com.instabug.library.PresentationManager;
import com.instabug.library.R;
import com.instabug.library.core.CurrentFragmentLifeCycleEventBus;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.ActivityLifecycleSubscriber;
import com.instabug.library.core.eventbus.DefaultActivityLifeCycleEventHandler;
import com.instabug.library.internal.servicelocator.CoreServiceLocator;
import com.instabug.library.invocation.InvocationManagerContract;
import com.instabug.library.screenshot.ScreenshotCaptor;
import com.instabug.library.screenshot.instacapture.ScreenshotRequest;
import com.instabug.library.screenshot.instacapture.q;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tracking.FragmentLifeCycleEvent;
import com.instabug.library.tracking.InstabugInternalTrackingDelegate;
import com.instabug.library.util.BitmapUtils;
import com.instabug.library.util.Colorizer;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.LocaleUtils;
import com.instabug.library.util.ScreenUtility;
import com.instabug.library.view.ViewUtils;
import io.reactivexport.disposables.Disposable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;

public class ExtraScreenshotHelper
implements DefaultActivityLifeCycleEventHandler {
    @Nullable
    @VisibleForTesting
    public WeakReference<ImageButton> captureBtnWeakReference;
    @VisibleForTesting
    public boolean isCaptureBtnShown = false;
    @Nullable
    @VisibleForTesting
    public ActivityLifecycleSubscriber currentActivityLifeCycleSubscriber;
    @Nullable
    @VisibleForTesting
    public Disposable fragmentsLifeCycleSubscriber;
    @Nullable
    @VisibleForTesting
    public OnCaptureListener onCaptureListener;

    /*
     * WARNING - void declaration
     */
    @MainThread
    private void show(@NonNull Activity hostActivity) {
        void var1_1;
        this.show((Activity)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    private FrameLayout.LayoutParams createCaptureButtonContainer(Activity hostActivity) {
        FrameLayout.LayoutParams layoutParams;
        ExtraScreenshotHelper extraScreenshotHelper = layoutParams;
        new FrameLayout.LayoutParams(-2, -2, 81).setMargins(0, 0, 0, 20);
        if (ScreenUtility.hasNavBar((Context)hostActivity) && Build.VERSION.SDK_INT >= 21) {
            void var1_1;
            ExtraScreenshotHelper extraScreenshotHelper2 = extraScreenshotHelper;
            ((FrameLayout.LayoutParams)extraScreenshotHelper2).bottomMargin += ScreenUtility.getBottomInsets((Activity)var1_1);
            return extraScreenshotHelper2;
        }
        return extraScreenshotHelper;
    }

    /*
     * WARNING - void declaration
     */
    private void captureExtraScreenshot(Activity hostActivity, @Nullable OnCaptureListener onCaptureListener) {
        void var1_1;
        void var2_2;
        ScreenshotCaptor.CapturingCallback capturingCallback = ((ExtraScreenshotHelper)((Object)capturingCallback)).createCapturingListener((OnCaptureListener)var2_2);
        CoreServiceLocator.getScreenshotCaptor().capture(ScreenshotRequest.createScreenshotRequest(new q(1, (Activity)var1_1, capturingCallback)));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    private ScreenshotCaptor.CapturingCallback createCapturingListener(@Nullable OnCaptureListener onCaptureListener) {
        void var1_1;
        return new ScreenshotCaptor.CapturingCallback(this, (OnCaptureListener)var1_1){
            final /* synthetic */ OnCaptureListener a;
            final /* synthetic */ ExtraScreenshotHelper b;
            {
                void var1_1;
                this.b = var1_1;
                this.a = onCaptureListener;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void onCapturingSuccess(Bitmap bitmap) {
                void var1_1;
                ExtraScreenshotHelper.access$000(this.b, (Bitmap)var1_1, this.a);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void onCapturingFailure(Throwable throwable) {
                void var1_1;
                OnCaptureListener onCaptureListener = this.a;
                if (onCaptureListener != null) {
                    onCaptureListener.onExtraScreenshotError((Throwable)var1_1);
                }
                ExtraScreenshotHelper extraScreenshotHelper = this.b;
                ExtraScreenshotHelper.access$100(extraScreenshotHelper, extraScreenshotHelper::hide);
                InstabugSDKLogger.e("IBG-Core", "Error while capturing screenshot: " + var1_1.getMessage());
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private void saveBitmap(Bitmap bitmap, @Nullable OnCaptureListener onCaptureListener) {
        Activity activity = InstabugInternalTrackingDelegate.getInstance().getCurrentActivity();
        if (activity != null) {
            void var2_2;
            BitmapUtils.OnSaveBitmapCallback onSaveBitmapCallback;
            BitmapUtils.OnSaveBitmapCallback onSaveBitmapCallback2;
            void v02 = onSaveBitmapCallback2;
            onSaveBitmapCallback2 = onSaveBitmapCallback;
            onSaveBitmapCallback = new BitmapUtils.OnSaveBitmapCallback(this, (OnCaptureListener)var2_2){
                final /* synthetic */ OnCaptureListener a;
                final /* synthetic */ ExtraScreenshotHelper b;
                {
                    void var1_1;
                    this.b = var1_1;
                    this.a = onCaptureListener;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void onSuccess(Uri screenshotUri) {
                    void var1_1;
                    InstabugSDKLogger.v("IBG-Core", "Saving screenshot file to: " + var1_1.toString());
                    OnCaptureListener this_ = this_.a;
                    if (this_ != null) {
                        this_.onExtraScreenshotCaptured((Uri)var1_1);
                        return;
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void onError(Throwable throwable) {
                    void var1_1;
                    InstabugSDKLogger.e("IBG-Core", "Error while saving screenshot: " + var1_1.getMessage());
                }
            };
            BitmapUtils.saveBitmap((Bitmap)v02, (Context)activity, onSaveBitmapCallback2);
            return;
        }
    }

    private void subscribeToCurranActivityLifeCycle() {
        if (this.currentActivityLifeCycleSubscriber == null) {
            this.currentActivityLifeCycleSubscriber = CoreServiceLocator.createActivityLifecycleSubscriber(this);
        }
        this.currentActivityLifeCycleSubscriber.subscribe();
    }

    private void subscribeToFragmentsLifecycle() {
        if (this.fragmentsLifeCycleSubscriber != null) {
            return;
        }
        this.fragmentsLifeCycleSubscriber = CurrentFragmentLifeCycleEventBus.getInstance().subscribe(event -> {
            void var1_1;
            if (event == FragmentLifeCycleEvent.RESUMED) {
                this.handleFragmentResumed();
                return;
            }
            if (var1_1 == FragmentLifeCycleEvent.DETACHED) {
                this.reset(null);
                return;
            }
        });
    }

    private void handleFragmentResumed() {
        Object object = InstabugCore.getLastSeenView();
        if (!(object instanceof BottomSheetDialogFragment) || (object = (DialogFragment)object).getDialog() == null || !object.isResumed() || object.isRemoving() || object.isDetached()) {
            return;
        }
        ExtraScreenshotHelper extraScreenshotHelper = this;
        extraScreenshotHelper.runOnUiThread(() -> extraScreenshotHelper.lambda$handleFragmentResumed$4(object.getDialog().getWindow()));
    }

    /*
     * WARNING - void declaration
     */
    private void runOnUiThread(Runnable runnable) {
        void var1_1;
        ExtraScreenshotHelper extraScreenshotHelper = InstabugInternalTrackingDelegate.getInstance().getCurrentActivity();
        if (extraScreenshotHelper == null) {
            return;
        }
        extraScreenshotHelper.runOnUiThread((Runnable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$handleFragmentResumed$4(Window dialogWindow) {
        void var1_1;
        this.reset((Window)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$reset$1(Window currentWindow) {
        void var1_1;
        Activity activity = InstabugInternalTrackingDelegate.getInstance().getCurrentActivity();
        if (activity == null) {
            return;
        }
        ExtraScreenshotHelper extraScreenshotHelper = this;
        extraScreenshotHelper.hide();
        extraScreenshotHelper.show(activity, (Window)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$show$0(Activity hostActivity, View v2) {
        void var1_1;
        ExtraScreenshotHelper extraScreenshotHelper = this;
        extraScreenshotHelper.hide();
        extraScreenshotHelper.captureExtraScreenshot((Activity)var1_1, extraScreenshotHelper.onCaptureListener);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(ExtraScreenshotHelper x02, Bitmap x12, OnCaptureListener x2) {
        void var2_2;
        void var1_1;
        x02.saveBitmap((Bitmap)var1_1, (OnCaptureListener)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$100(ExtraScreenshotHelper x02, Runnable x12) {
        void var1_1;
        x02.runOnUiThread((Runnable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"NULL_DEREFERENCE"})
    public void init(OnCaptureListener onCaptureListener) {
        void var1_1;
        ExtraScreenshotHelper extraScreenshotHelper = this_;
        extraScreenshotHelper.onCaptureListener = var1_1;
        extraScreenshotHelper.subscribeToCurranActivityLifeCycle();
        extraScreenshotHelper.subscribeToFragmentsLifecycle();
        InvocationManagerContract this_ = CoreServiceLocator.getInvocationManagerContract();
        if (this_ != null) {
            this_.switchOffInvocation();
        }
        PresentationManager.getInstance().setInInstabugContext(true);
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public void release() {
        Object object = ((ExtraScreenshotHelper)((Object)this_)).captureBtnWeakReference;
        if (object != null && (object = (View)((Reference)object).get()) != null) {
            object.setOnClickListener(null);
        }
        ((ExtraScreenshotHelper)((Object)this_)).onCaptureListener = null;
        ((ExtraScreenshotHelper)((Object)this_)).captureBtnWeakReference = null;
        object = ((ExtraScreenshotHelper)((Object)this_)).currentActivityLifeCycleSubscriber;
        if (object != null) {
            object.unsubscribe();
            ((ExtraScreenshotHelper)((Object)this_)).currentActivityLifeCycleSubscriber = null;
        }
        if ((object = ((ExtraScreenshotHelper)((Object)this_)).fragmentsLifeCycleSubscriber) != null) {
            object.dispose();
            ((ExtraScreenshotHelper)((Object)this_)).fragmentsLifeCycleSubscriber = null;
        }
        PresentationManager.getInstance().setInInstabugContext(false);
        InvocationManagerContract this_ = CoreServiceLocator.getInvocationManagerContract();
        if (this_ != null) {
            this_.switchOnInvocation();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @MainThread
    @VisibleForTesting
    public void show(@NonNull Activity hostActivity, @Nullable Window window) {
        if (!this.isCaptureBtnShown && !SettingsManager.getInstance().isProcessingForeground()) {
            Window window2;
            void var1_2;
            ImageButton imageButton = this.createCaptureButton((Activity)var1_2);
            ViewCompat.setElevation((View)imageButton, (float)ViewUtils.convertDpToPx(var1_2.getApplicationContext(), 5.0f));
            if (window2 == null) {
                window2 = var1_2.getWindow();
            }
            window2 = (ViewGroup)window2.getDecorView();
            int n2 = window2.getChildCount();
            window2.addView((View)imageButton, n2, (ViewGroup.LayoutParams)this.createCaptureButtonContainer((Activity)var1_2));
            this.isCaptureBtnShown = true;
            imageButton.setOnClickListener(arg_0 -> this.lambda$show$0((Activity)var1_2, arg_0));
            this.captureBtnWeakReference = new WeakReference<ImageButton>(imageButton);
            return;
        }
    }

    @VisibleForTesting
    public ImageButton createCaptureButton(Activity hostActivity) {
        Drawable drawable2;
        ImageButton imageButton;
        ExtraScreenshotHelper extraScreenshotHelper = imageButton;
        new ImageButton((Context)drawable2).setId(R.id.instabug_extra_screenshot_button);
        extraScreenshotHelper.setScaleType(ImageView.ScaleType.CENTER);
        int n2 = R.string.ibg_extra_screenshot_button_content_description;
        extraScreenshotHelper.setContentDescription(LocaleUtils.getLocaleStringResource(InstabugCore.getLocale(extraScreenshotHelper.getContext()), n2, extraScreenshotHelper.getContext()));
        Drawable drawable3 = ContextCompat.getDrawable((Context)hostActivity, (int)R.drawable.ibg_core_bg_white_oval);
        drawable2 = AppCompatResources.getDrawable((Context)drawable2, (int)R.drawable.ibg_core_ic_screenshot);
        if (drawable3 != null) {
            extraScreenshotHelper.setBackgroundDrawable(Colorizer.getPrimaryColorTintedDrawable(drawable3));
        }
        if (drawable2 != null) {
            ExtraScreenshotHelper extraScreenshotHelper2 = extraScreenshotHelper;
            extraScreenshotHelper2.setImageDrawable(drawable2);
            return extraScreenshotHelper2;
        }
        return extraScreenshotHelper;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public void reset(@Nullable Window currentWindow) {
        void var1_1;
        ExtraScreenshotHelper extraScreenshotHelper = this;
        extraScreenshotHelper.runOnUiThread(() -> extraScreenshotHelper.lambda$reset$1((Window)var1_1));
    }

    @MainThread
    @VisibleForTesting
    public void hide() {
        ImageButton imageButton = this.captureBtnWeakReference;
        if (imageButton != null && this.isCaptureBtnShown && (imageButton = (ImageButton)imageButton.get()) != null && imageButton.getParent() instanceof ViewGroup) {
            ExtraScreenshotHelper extraScreenshotHelper = this;
            ViewGroup viewGroup = (ViewGroup)imageButton.getParent();
            ImageButton imageButton2 = imageButton;
            imageButton2.setOnClickListener(null);
            viewGroup.removeView((View)imageButton2);
            extraScreenshotHelper.isCaptureBtnShown = false;
            extraScreenshotHelper.captureBtnWeakReference = null;
            return;
        }
    }

    @Override
    public void handleActivityResumed() {
        Activity activity = InstabugInternalTrackingDelegate.getInstance().getCurrentActivity();
        if (activity == null) {
            InstabugSDKLogger.v("IBG-Core", "Couldn't handle resume event current activity equal null");
            return;
        }
        ExtraScreenshotHelper extraScreenshotHelper = this;
        extraScreenshotHelper.runOnUiThread(() -> {
            void var1_1;
            this.show((Activity)var1_1);
        });
    }

    @Override
    public void handleActivityPaused() {
        ExtraScreenshotHelper extraScreenshotHelper = this;
        extraScreenshotHelper.runOnUiThread(extraScreenshotHelper::hide);
    }

    public void cancel() {
        ExtraScreenshotHelper extraScreenshotHelper = this;
        extraScreenshotHelper.runOnUiThread(() -> {
            ExtraScreenshotHelper extraScreenshotHelper = this;
            extraScreenshotHelper.hide();
            extraScreenshotHelper.release();
        });
    }

    public static interface OnCaptureListener {
        public void onExtraScreenshotCaptured(Uri var1);

        public void onExtraScreenshotError(Throwable var1);
    }
}

