/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.model;

import android.annotation.SuppressLint;
import android.webkit.MimeTypeMap;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.library.internal.storage.cache.Cacheable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Attachment
implements Cacheable,
Serializable {
    static final String KEY_NAME = "name";
    static final String KEY_LOCALE_PATH = "local_path";
    static final String KEY_URL = "url";
    static final String KEY_TYPE = "type";
    static final String KEY_ATTACHMENT_STATE = "attachment_state";
    static final String KEY_VIDEO_ENCODED = "video_encoded";
    static final String KEY_DURATION = "duration";
    private static final String KEY_ENCRYPTED = "isEncrypted";
    private long id;
    @Nullable
    private String name;
    @Nullable
    private String localPath;
    @Nullable
    private String url;
    @Nullable
    private Type type;
    @Nullable
    private AttachmentState attachmentState;
    private boolean isVideoEncoded;
    @Nullable
    private String duration;
    private boolean isEncrypted;
    private boolean shouldAnimate;
    private boolean isRemoved;

    public Attachment() {
        Attachment attachment = this;
        attachment.id = -1L;
        attachment.isVideoEncoded = false;
        attachment.isEncrypted = false;
        attachment.shouldAnimate = true;
        attachment.isRemoved = false;
        attachment.setType(Type.NOT_AVAILABLE);
        attachment.setAttachmentState(AttachmentState.NOT_AVAILABLE);
    }

    public static JSONArray toJson(List<Attachment> attachments) throws JSONException {
        JSONArray jSONArray;
        JSONArray jSONArray2 = jSONArray;
        jSONArray = new JSONArray();
        if (attachments != null) {
            List<Attachment> list;
            for (int i2 = 0; i2 < list.size(); ++i2) {
                jSONArray2.put((Object)new JSONObject(list.get(i2).toJson()));
            }
        }
        return jSONArray2;
    }

    public static List<Attachment> fromJson(JSONArray attachmentsJsonArray) throws JSONException {
        JSONArray jSONArray;
        ArrayList<Attachment> arrayList;
        ArrayList<Attachment> arrayList2 = arrayList;
        arrayList = new ArrayList<Attachment>();
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            Attachment attachment;
            Attachment attachment2 = attachment;
            attachment2();
            attachment.fromJson(jSONArray.getJSONObject(i2).toString());
            arrayList2.add(attachment);
        }
        return arrayList2;
    }

    public long getId() {
        return this.id;
    }

    /*
     * WARNING - void declaration
     */
    public void setId(long id2) {
        void var1_1;
        this.id = var1_1;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - void declaration
     */
    public Attachment setName(@Nullable String name) {
        void var1_1;
        this.name = var1_1;
        return this;
    }

    @Nullable
    public String getLocalPath() {
        return this.localPath;
    }

    /*
     * WARNING - void declaration
     */
    public Attachment setLocalPath(@Nullable String localPath) {
        void var1_1;
        this.localPath = var1_1;
        return this;
    }

    @Nullable
    public String getUrl() {
        return this.url;
    }

    /*
     * WARNING - void declaration
     */
    public Attachment setUrl(String url) {
        void var1_1;
        this.url = var1_1;
        return this;
    }

    @Nullable
    public Type getType() {
        return this.type;
    }

    /*
     * WARNING - void declaration
     */
    public Attachment setType(Type type) {
        void var1_1;
        this.type = var1_1;
        return this;
    }

    public boolean shouldAnimate() {
        return this.shouldAnimate;
    }

    /*
     * WARNING - void declaration
     */
    public void setShouldAnimate(boolean shouldAnimate) {
        void var1_1;
        this.shouldAnimate = var1_1;
    }

    public boolean isVideoEncoded() {
        return this.isVideoEncoded;
    }

    /*
     * WARNING - void declaration
     */
    public Attachment setVideoEncoded(boolean videoEncoded) {
        void var1_1;
        this.isVideoEncoded = var1_1;
        return this;
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public String getFileType() {
        Attachment attachment = this_;
        String string2 = MimeTypeMap.getFileExtensionFromUrl((String)attachment.getName());
        String this_ = attachment.getType() == null ? "" : ((Attachment)((Object)this_)).getType().toString();
        if (string2 != null && !string2.equals("") && (string2 = MimeTypeMap.getSingleton().getMimeTypeFromExtension(string2)) != null && !string2.equals("")) {
            return string2;
        }
        return this_;
    }

    @Nullable
    public AttachmentState getAttachmentState() {
        return this.attachmentState;
    }

    /*
     * WARNING - void declaration
     */
    public Attachment setAttachmentState(AttachmentState attachmentState) {
        void var1_1;
        this.attachmentState = var1_1;
        return this;
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    /*
     * WARNING - void declaration
     */
    public void setEncrypted(boolean encrypted) {
        void var1_1;
        this.isEncrypted = var1_1;
    }

    @Nullable
    public String getDuration() {
        return this.duration;
    }

    /*
     * WARNING - void declaration
     */
    public void setDuration(@Nullable String duration) {
        void var1_1;
        this.duration = var1_1;
    }

    @Override
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public String toJson() throws JSONException {
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        jSONObject2();
        jSONObject.put(KEY_NAME, (Object)this.getName()).put(KEY_LOCALE_PATH, (Object)this.getLocalPath()).put(KEY_URL, (Object)this.getUrl()).put(KEY_VIDEO_ENCODED, this.isVideoEncoded()).put(KEY_ENCRYPTED, this.isEncrypted()).put(KEY_DURATION, (Object)this.getDuration());
        if (this.getType() != null) {
            jSONObject2.put(KEY_TYPE, (Object)this.getType().toString());
        }
        if (this.getAttachmentState() != null) {
            jSONObject2.put(KEY_ATTACHMENT_STATE, (Object)((Object)((Object)this.getAttachmentState())).toString());
        }
        return jSONObject2.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fromJson(String attachmentAsJson) throws JSONException {
        void var1_1;
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        if (new JSONObject((String)var1_1).has(KEY_NAME)) {
            this.setName(jSONObject2.getString(KEY_NAME));
        }
        if (jSONObject2.has(KEY_LOCALE_PATH)) {
            this.setLocalPath(jSONObject2.getString(KEY_LOCALE_PATH));
        }
        if (jSONObject2.has(KEY_URL)) {
            this.setUrl(jSONObject2.getString(KEY_URL));
        }
        if (jSONObject2.has(KEY_TYPE)) {
            this.setType(Type.get(jSONObject2.getString(KEY_TYPE)));
        }
        if (jSONObject2.has(KEY_ATTACHMENT_STATE)) {
            this.setAttachmentState(AttachmentState.valueOf(jSONObject2.getString(KEY_ATTACHMENT_STATE)));
        }
        if (jSONObject2.has(KEY_VIDEO_ENCODED)) {
            this.setVideoEncoded(jSONObject2.getBoolean(KEY_VIDEO_ENCODED));
        }
        if (jSONObject2.has(KEY_DURATION)) {
            this.setDuration(jSONObject2.getString(KEY_DURATION));
        }
        if (jSONObject2.has(KEY_ENCRYPTED)) {
            this.setEncrypted(jSONObject2.getBoolean(KEY_ENCRYPTED));
            return;
        }
    }

    public boolean isRemoved() {
        return this.isRemoved;
    }

    /*
     * WARNING - void declaration
     */
    public void setRemoved(boolean removed) {
        void var1_1;
        this.isRemoved = var1_1;
    }

    @NonNull
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public String toString() {
        return "Name: " + this.getName() + ", Local Path: " + this.getLocalPath() + ", Type: " + (Object)((Object)this.getType()) + ", Duration: " + this.getDuration() + ", Url: " + this.getUrl() + ", Attachment State: " + (Object)((Object)this.getAttachmentState());
    }

    @SuppressLint(value={"NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"})
    public boolean equals(@Nullable Object attachment) {
        Attachment attachment2;
        if (attachment == null) {
            return false;
        }
        if (attachment2 instanceof Attachment) {
            return String.valueOf((attachment2 = (Attachment)attachment2).getName()).equals(String.valueOf(this.getName())) && String.valueOf(attachment2.getLocalPath()).equals(String.valueOf(this.getLocalPath())) && String.valueOf(attachment2.getUrl()).equals(String.valueOf(this.getUrl())) && attachment2.getType() == this.getType() && attachment2.getAttachmentState() == this.getAttachmentState() && attachment2.isVideoEncoded() == this.isVideoEncoded() && String.valueOf(attachment2.getDuration()).equals(String.valueOf(this.getDuration()));
        }
        return false;
    }

    public int hashCode() {
        if (this.getName() != null) {
            return this.getName().hashCode();
        }
        return -1;
    }

    public static enum Type {
        MAIN_SCREENSHOT("main-screenshot"),
        AUDIO("audio"),
        EXTRA_IMAGE("extra_image"),
        EXTRA_VIDEO("extra_video"),
        GALLERY_IMAGE("image_gallery"),
        GALLERY_VIDEO("video_gallery"),
        ATTACHMENT_FILE("attachment-file"),
        VIEW_HIERARCHY("view-hierarchy-v2"),
        NOT_AVAILABLE("not-available"),
        VISUAL_USER_STEPS("user-repro-steps-v2"),
        AUTO_SCREEN_RECORDING_VIDEO("auto-screen-recording-v2");

        private static final Map<String, Type> lookup;
        private final String name;

        /*
         * WARNING - void declaration
         */
        private Type(String name) {
            void var3_3;
            this.name = var3_3;
        }

        public static Type get(String name) {
            Object object;
            if ((object = lookup.get(object)) == null) {
                return NOT_AVAILABLE;
            }
            return object;
        }

        static {
            lookup = new HashMap<String, Type>();
            for (Type type : Type.values()) {
                lookup.put(type.name, type);
            }
        }

        @NonNull
        public String toString() {
            return this.name;
        }
    }

    public static enum AttachmentState {
        OFFLINE,
        SYNCED,
        NOT_AVAILABLE;

    }
}

