/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage.cache.dbv2;

import android.annotation.SuppressLint;
import android.content.ContentValues;
import android.content.Context;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.library.Instabug;
import com.instabug.library.apichecker.ReturnableRunnable;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.diagnostics.IBGDiagnostics;
import com.instabug.library.internal.storage.cache.dbv2.IBGContentValues;
import com.instabug.library.internal.storage.cache.dbv2.IBGCursor;
import com.instabug.library.internal.storage.cache.dbv2.IBGWhereArg;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import java.util.Arrays;
import java.util.List;

public class IBGDbManager {
    @VisibleForTesting
    public static SQLiteOpenHelper dbHelper;
    @Nullable
    private static IBGDbManager instance;
    @Nullable
    private Boolean databaseTransactionsEnabled;
    @Nullable
    private SQLiteDatabase database;

    public static synchronized void init(com.instabug.library.internal.storage.cache.dbv2.a helper) {
        if (instance == null) {
            com.instabug.library.internal.storage.cache.dbv2.a a2;
            instance = new IBGDbManager();
            dbHelper = a2;
            return;
        }
    }

    @SuppressLint(value={"RESOURCE_LEAK"})
    public static synchronized IBGDbManager getInstance() throws IllegalStateException {
        if (instance == null) {
            if (Instabug.getApplicationContext() != null) {
                IBGDbManager.init(new com.instabug.library.internal.storage.cache.dbv2.a(Instabug.getApplicationContext()));
            } else {
                throw new IllegalStateException("IBG-Core is not initialized, call init(..) method first.");
            }
        }
        return instance;
    }

    private IBGDbManager() {
    }

    private synchronized void openDatabase() {
        SQLiteDatabase sQLiteDatabase = this.database;
        if (sQLiteDatabase != null && sQLiteDatabase.isOpen()) {
            return;
        }
        this.database = dbHelper.getWritableDatabase();
    }

    private synchronized boolean databaseInitializedAndOpen() {
        IBGDbManager this_ = this_.database;
        return this_ != null && this_.isOpen();
    }

    @VisibleForTesting
    @SuppressLint(value={"ERADICATE_FIELD_NOT_NULLABLE"})
    public static synchronized void tearDown() {
        Object object = dbHelper;
        if (object != null) {
            object.close();
            dbHelper = null;
        }
        if ((object = instance) != null) {
            object = object.database;
            if (object != null) {
                object.close();
                IBGDbManager.instance.database = null;
            }
            instance = null;
            return;
        }
    }

    private synchronized boolean isDatabaseTransactionsEnabled() {
        if (((IBGDbManager)this).databaseTransactionsEnabled == null && Instabug.getApplicationContext() != null) {
            ((IBGDbManager)this).databaseTransactionsEnabled = InstabugCore.isDatabaseTransactionDisabled() ^ true;
        }
        if ((this = ((IBGDbManager)this).databaseTransactionsEnabled) != null) {
            return (Boolean)this;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void logOperationFailedWarning(String message) {
        void var1_1;
        IBGDbManager this_ = this_.database;
        if (this_ == null) {
            InstabugSDKLogger.e("IBG-Core", "Attempted to do operation on an uninitialized database. Falling back silently");
            return;
        }
        if (!this_.isOpen()) {
            InstabugSDKLogger.e("IBG-Core", "Attempted to do operation on a closed database. Falling back silently");
            return;
        }
        InstabugSDKLogger.w("IBG-Core", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$300(IBGDbManager x02, String x12) {
        void var1_1;
        x02.logOperationFailedWarning((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public long insert(@NonNull String table, @Nullable String nullColumnHack, @NonNull IBGContentValues values) {
        void var3_3;
        void var2_2;
        void var1_1;
        Long l2 = (Long)PoolProvider.getDatabaseExecutor().executeAndGet(new ReturnableRunnable((IBGDbManager)((Object)l2), (String)var1_1, (String)var2_2, (IBGContentValues)var3_3){
            final /* synthetic */ String a;
            final /* synthetic */ String b;
            final /* synthetic */ IBGContentValues c;
            final /* synthetic */ IBGDbManager d;
            {
                void var1_1;
                this.d = var1_1;
                this.a = string2;
                this.b = string3;
                this.c = iBGContentValues;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Long run() {
                Exception exception2;
                block5: {
                    OutOfMemoryError outOfMemoryError2;
                    block4: {
                        a a2 = this;
                        a2.d.openDatabase();
                        try {
                            if (a2.d.databaseInitializedAndOpen()) {
                                a a3 = this;
                                String string2 = a3.a;
                                String string3 = a3.b;
                                return this.d.database.insertOrThrow(string2, string3, this.c.toContentValues());
                            }
                        }
                        catch (OutOfMemoryError outOfMemoryError2) {
                            break block4;
                        }
                        catch (Exception exception2) {
                            break block5;
                        }
                        IBGDbManager.access$300(this.d, "DB insertion failed, database not initialized");
                        return -1L;
                    }
                    IBGDiagnostics.reportNonFatal(outOfMemoryError2, "DB insertion failed: " + outOfMemoryError2.getMessage() + Arrays.toString(outOfMemoryError2.getStackTrace()));
                    IBGDbManager.access$300(this.d, "DB insertion failed due to: " + outOfMemoryError2.getMessage() + Arrays.toString(outOfMemoryError2.getStackTrace()));
                    return -1L;
                }
                IBGDiagnostics.reportNonFatal(exception2, "DB insertion failed: " + exception2.getMessage() + Arrays.toString(exception2.getStackTrace()));
                IBGDbManager.access$300(this.d, "DB insertion failed due to: " + exception2.getMessage() + Arrays.toString(exception2.getStackTrace()));
                return -1L;
            }
        });
        if (l2 == null) {
            return -1L;
        }
        return l2;
    }

    /*
     * WARNING - void declaration
     */
    public long insertWithOnConflict(@NonNull String tableName, @Nullable String nullColumnHack, @NonNull IBGContentValues values) {
        void var3_3;
        void var2_2;
        void var1_1;
        Long l2 = (Long)PoolProvider.getDatabaseExecutor().executeAndGet(new ReturnableRunnable((IBGDbManager)((Object)l2), (String)var1_1, (String)var2_2, (IBGContentValues)var3_3){
            final /* synthetic */ String a;
            final /* synthetic */ String b;
            final /* synthetic */ IBGContentValues c;
            final /* synthetic */ IBGDbManager d;
            {
                void var1_1;
                this.d = var1_1;
                this.a = string2;
                this.b = string3;
                this.c = iBGContentValues;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Long run() {
                Exception exception2;
                block5: {
                    OutOfMemoryError outOfMemoryError2;
                    block4: {
                        b b2 = this;
                        b2.d.openDatabase();
                        try {
                            if (b2.d.databaseInitializedAndOpen()) {
                                b b3 = this;
                                String string2 = b3.a;
                                String string3 = b3.b;
                                return this.d.database.insertWithOnConflict(string2, string3, this.c.toContentValues(), 4);
                            }
                        }
                        catch (OutOfMemoryError outOfMemoryError2) {
                            break block4;
                        }
                        catch (Exception exception2) {
                            break block5;
                        }
                        IBGDbManager.access$300(this.d, "DB insertion with on conflict failed database is not initialized");
                        return -1L;
                    }
                    IBGDiagnostics.reportNonFatal(outOfMemoryError2, "DB insertion with on conflict failed: " + outOfMemoryError2.getMessage() + Arrays.toString(outOfMemoryError2.getStackTrace()));
                    IBGDbManager.access$300(this.d, "DB insertion with on conflict failed due to: " + outOfMemoryError2.getMessage() + Arrays.toString(outOfMemoryError2.getStackTrace()));
                    return -1L;
                }
                IBGDiagnostics.reportNonFatal(exception2, "DB insertion with on conflict failed: " + exception2.getMessage() + Arrays.toString(exception2.getStackTrace()));
                IBGDbManager.access$300(this.d, "DB insertion with on conflict failed due to: " + exception2.getMessage() + Arrays.toString(exception2.getStackTrace()));
                return -1L;
            }
        });
        if (l2 == null) {
            return -1L;
        }
        return l2;
    }

    /*
     * WARNING - void declaration
     */
    public void execSQL(@NonNull String sql, @Nullable Object[] args) {
        void var2_2;
        void var1_1;
        PoolProvider.getDatabaseExecutor().execute(new Runnable(this, (String)var1_1, (Object[])var2_2){
            final /* synthetic */ String a;
            final /* synthetic */ Object[] b;
            final /* synthetic */ IBGDbManager c;
            {
                void var1_1;
                this.c = var1_1;
                this.a = string2;
                this.b = objectArray;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                Exception exception2;
                block5: {
                    OutOfMemoryError outOfMemoryError2;
                    block4: {
                        c c2 = this;
                        c2.c.openDatabase();
                        try {
                            if (c2.c.databaseInitializedAndOpen()) {
                                c c3 = this;
                                String string2 = c3.a;
                                this.c.database.execSQL(string2, c3.b);
                                return;
                            }
                        }
                        catch (OutOfMemoryError outOfMemoryError2) {
                            break block4;
                        }
                        catch (Exception exception2) {
                            break block5;
                        }
                        IBGDbManager.access$300(this.c, "DB execution a sql failed");
                        return;
                    }
                    IBGDiagnostics.reportNonFatal(outOfMemoryError2, "DB execution a sql failed: " + outOfMemoryError2.getMessage() + Arrays.toString(outOfMemoryError2.getStackTrace()));
                    IBGDbManager.access$300(this.c, "DB execution a sql failed due to: " + outOfMemoryError2.getMessage() + Arrays.toString(outOfMemoryError2.getStackTrace()));
                    return;
                }
                IBGDiagnostics.reportNonFatal(exception2, "DB execution a sql failed: " + exception2.getMessage() + Arrays.toString(exception2.getStackTrace()));
                IBGDbManager.access$300(this.c, "DB execution a sql failed due to: " + exception2.getMessage() + Arrays.toString(exception2.getStackTrace()));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public long insertWithOnConflictReplace(@NonNull String tableName, @Nullable String nullColumnHack, @NonNull IBGContentValues values) {
        void var3_3;
        void var2_2;
        void var1_1;
        Long l2 = (Long)PoolProvider.getDatabaseExecutor().executeAndGet(new ReturnableRunnable((IBGDbManager)((Object)l2), (String)var1_1, (String)var2_2, (IBGContentValues)var3_3){
            final /* synthetic */ String a;
            final /* synthetic */ String b;
            final /* synthetic */ IBGContentValues c;
            final /* synthetic */ IBGDbManager d;
            {
                void var1_1;
                this.d = var1_1;
                this.a = string2;
                this.b = string3;
                this.c = iBGContentValues;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Long run() {
                Exception exception2;
                block5: {
                    OutOfMemoryError outOfMemoryError2;
                    block4: {
                        d d2 = this;
                        d2.d.openDatabase();
                        try {
                            if (d2.d.databaseInitializedAndOpen()) {
                                d d3 = this;
                                String string2 = d3.a;
                                String string3 = d3.b;
                                return this.d.database.insertWithOnConflict(string2, string3, this.c.toContentValues(), 5);
                            }
                        }
                        catch (OutOfMemoryError outOfMemoryError2) {
                            break block4;
                        }
                        catch (Exception exception2) {
                            break block5;
                        }
                        IBGDbManager.access$300(this.d, "DB insertion with on conflict replace failed");
                        return -1L;
                    }
                    IBGDiagnostics.reportNonFatal(outOfMemoryError2, "DB insertion with on conflict replace failed: " + outOfMemoryError2.getMessage() + Arrays.toString(outOfMemoryError2.getStackTrace()));
                    IBGDbManager.access$300(this.d, "DB insertion with on conflict replace failed due to: " + outOfMemoryError2.getMessage() + Arrays.toString(outOfMemoryError2.getStackTrace()));
                    return -1L;
                }
                IBGDiagnostics.reportNonFatal(exception2, "DB insertion with on conflict replace failed: " + exception2.getMessage() + Arrays.toString(exception2.getStackTrace()));
                IBGDbManager.access$300(this.d, "DB insertion with on conflict replace failed due to: " + exception2.getMessage() + Arrays.toString(exception2.getStackTrace()));
                return -1L;
            }
        });
        if (l2 == null) {
            return -1L;
        }
        return l2;
    }

    /*
     * WARNING - void declaration
     */
    public int delete(@NonNull String table, @Nullable String whereClause, @Nullable List<IBGWhereArg> whereArgs) {
        void var3_3;
        void var2_2;
        void var1_1;
        Integer n2 = (Integer)PoolProvider.getDatabaseExecutor().executeAndGet(new ReturnableRunnable((IBGDbManager)((Object)n2), (String)var1_1, (String)var2_2, (List)var3_3){
            final /* synthetic */ String a;
            final /* synthetic */ String b;
            final /* synthetic */ List c;
            final /* synthetic */ IBGDbManager d;
            {
                void var1_1;
                this.d = var1_1;
                this.a = string2;
                this.b = string3;
                this.c = list;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Integer run() {
                Exception exception2;
                block5: {
                    OutOfMemoryError outOfMemoryError2;
                    block4: {
                        e e2 = this;
                        e2.d.openDatabase();
                        try {
                            if (e2.d.databaseInitializedAndOpen()) {
                                e e3 = this;
                                String string2 = e3.a;
                                String string3 = e3.b;
                                return this.d.database.delete(string2, string3, IBGWhereArg.argsListToStringArray(this.c));
                            }
                        }
                        catch (OutOfMemoryError outOfMemoryError2) {
                            break block4;
                        }
                        catch (Exception exception2) {
                            break block5;
                        }
                        IBGDbManager.access$300(this.d, "DB deletion failed");
                        return 0;
                    }
                    IBGDiagnostics.reportNonFatal(outOfMemoryError2, "DB deletion failed: " + outOfMemoryError2.getMessage() + Arrays.toString(outOfMemoryError2.getStackTrace()));
                    IBGDbManager.access$300(this.d, "DB deletion failed due to: " + outOfMemoryError2.getMessage() + Arrays.toString(outOfMemoryError2.getStackTrace()));
                    return 0;
                }
                IBGDiagnostics.reportNonFatal(exception2, "DB deletion failed: " + exception2.getMessage() + Arrays.toString(exception2.getStackTrace()));
                IBGDbManager.access$300(this.d, "DB deletion failed due to: " + exception2.getMessage() + Arrays.toString(exception2.getStackTrace()));
                return 0;
            }
        });
        if (n2 == null) {
            return 0;
        }
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public IBGCursor query(String table, @Nullable String[] columns, @Nullable String selection, @Nullable List<IBGWhereArg> selectionArgs, @Nullable String groupBy, @Nullable String having, @Nullable String orderBy) {
        void var7_7;
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return (IBGCursor)PoolProvider.getDatabaseExecutor().executeAndGet(new ReturnableRunnable(this, (String)var1_1, (String[])var2_2, (String)var3_3, (List)var4_4, (String)var5_5, (String)var6_6, (String)var7_7){
            final /* synthetic */ String a;
            final /* synthetic */ String[] b;
            final /* synthetic */ String c;
            final /* synthetic */ List d;
            final /* synthetic */ String e;
            final /* synthetic */ String f;
            final /* synthetic */ String g;
            final /* synthetic */ IBGDbManager h;
            {
                void var1_1;
                this.h = var1_1;
                this.a = string2;
                this.b = stringArray;
                this.c = string3;
                this.d = list;
                this.e = string4;
                this.f = string5;
                this.g = string6;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public IBGCursor run() {
                Exception exception2;
                block5: {
                    OutOfMemoryError outOfMemoryError2;
                    block4: {
                        f f2 = this;
                        f2.h.openDatabase();
                        try {
                            if (f2.h.databaseInitializedAndOpen()) {
                                f f3 = this;
                                String string2 = f3.a;
                                String[] stringArray = f3.b;
                                String string3 = f3.c;
                                String[] stringArray2 = IBGWhereArg.argsListToStringArray(f3.d);
                                String string4 = f3.e;
                                String string5 = f3.f;
                                String string6 = f3.g;
                                return new IBGCursor(this.h.database.query(string2, stringArray, string3, stringArray2, string4, string5, string6));
                            }
                        }
                        catch (OutOfMemoryError outOfMemoryError2) {
                            break block4;
                        }
                        catch (Exception exception2) {
                            break block5;
                        }
                        IBGDbManager.access$300(this.h, "DB query faile");
                        return null;
                    }
                    IBGDiagnostics.reportNonFatal(outOfMemoryError2, "DB query failed: " + outOfMemoryError2.getMessage() + Arrays.toString(outOfMemoryError2.getStackTrace()));
                    IBGDbManager.access$300(this.h, "DB query faile due to: " + outOfMemoryError2.getMessage() + Arrays.toString(outOfMemoryError2.getStackTrace()));
                    return null;
                }
                IBGDiagnostics.reportNonFatal(exception2, "DB query failed: " + exception2.getMessage() + Arrays.toString(exception2.getStackTrace()));
                IBGDbManager.access$300(this.h, "DB query faile due to: " + exception2.getMessage() + Arrays.toString(exception2.getStackTrace()));
                return null;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public int update(@NonNull String table, @NonNull IBGContentValues values, @Nullable String whereClause, @Nullable List<IBGWhereArg> whereArgs) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Integer n2 = (Integer)PoolProvider.getDatabaseExecutor().executeAndGet(new ReturnableRunnable((IBGDbManager)((Object)n2), (String)var1_1, (IBGContentValues)var2_2, (String)var3_3, (List)var4_4){
            final /* synthetic */ String a;
            final /* synthetic */ IBGContentValues b;
            final /* synthetic */ String c;
            final /* synthetic */ List d;
            final /* synthetic */ IBGDbManager e;
            {
                void var1_1;
                this.e = var1_1;
                this.a = string2;
                this.b = iBGContentValues;
                this.c = string3;
                this.d = list;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Integer run() {
                Exception exception2;
                block5: {
                    OutOfMemoryError outOfMemoryError2;
                    block4: {
                        g g2 = this;
                        g2.e.openDatabase();
                        try {
                            if (g2.e.databaseInitializedAndOpen()) {
                                g g3 = this;
                                String[] stringArray = g3.a;
                                ContentValues contentValues = g3.b.toContentValues();
                                String string2 = g3.c;
                                String[] stringArray2 = stringArray;
                                stringArray = IBGWhereArg.argsListToStringArray(this.d);
                                return this.e.database.update((String)stringArray2, contentValues, string2, stringArray);
                            }
                        }
                        catch (OutOfMemoryError outOfMemoryError2) {
                            break block4;
                        }
                        catch (Exception exception2) {
                            break block5;
                        }
                        IBGDbManager.access$300(this.e, "DB update failed");
                        return -1;
                    }
                    IBGDiagnostics.reportNonFatal(outOfMemoryError2, "DB update failed: " + outOfMemoryError2.getMessage() + Arrays.toString(outOfMemoryError2.getStackTrace()));
                    IBGDbManager.access$300(this.e, "DB update failed due to: " + outOfMemoryError2.getMessage() + Arrays.toString(outOfMemoryError2.getStackTrace()));
                    return -1;
                }
                IBGDiagnostics.reportNonFatal(exception2, "DB update failed: " + exception2.getMessage() + Arrays.toString(exception2.getStackTrace()));
                IBGDbManager.access$300(this.e, "DB update failed due to: " + exception2.getMessage() + Arrays.toString(exception2.getStackTrace()));
                return -1;
            }
        });
        if (n2 == null) {
            return 0;
        }
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public IBGCursor query(String table, @Nullable String[] columns, @Nullable String selection, @Nullable List<IBGWhereArg> selectionArgs, @Nullable String groupBy, @Nullable String having, @Nullable String orderBy, @Nullable String limit) {
        void var8_8;
        void var7_7;
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return (IBGCursor)PoolProvider.getDatabaseExecutor().executeAndGet(new ReturnableRunnable(this, (String)var1_1, (String[])var2_2, (String)var3_3, (List)var4_4, (String)var5_5, (String)var6_6, (String)var7_7, (String)var8_8){
            final /* synthetic */ String a;
            final /* synthetic */ String[] b;
            final /* synthetic */ String c;
            final /* synthetic */ List d;
            final /* synthetic */ String e;
            final /* synthetic */ String f;
            final /* synthetic */ String g;
            final /* synthetic */ String h;
            final /* synthetic */ IBGDbManager i;
            {
                void var1_1;
                this.i = var1_1;
                this.a = string2;
                this.b = stringArray;
                this.c = string3;
                this.d = list;
                this.e = string4;
                this.f = string5;
                this.g = string6;
                this.h = string7;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public IBGCursor run() {
                Exception exception2;
                block5: {
                    OutOfMemoryError outOfMemoryError2;
                    block4: {
                        h h2 = this;
                        h2.i.openDatabase();
                        try {
                            if (h2.i.databaseInitializedAndOpen()) {
                                h h3 = this;
                                String string2 = h3.a;
                                String[] stringArray = h3.b;
                                String string3 = h3.c;
                                String[] stringArray2 = IBGWhereArg.argsListToStringArray(h3.d);
                                String string4 = h3.e;
                                String string5 = h3.f;
                                String string6 = h3.g;
                                String string7 = h3.h;
                                return new IBGCursor(this.i.database.query(string2, stringArray, string3, stringArray2, string4, string5, string6, string7));
                            }
                        }
                        catch (OutOfMemoryError outOfMemoryError2) {
                            break block4;
                        }
                        catch (Exception exception2) {
                            break block5;
                        }
                        IBGDbManager.access$300(this.i, "DB query failed");
                        return null;
                    }
                    IBGDiagnostics.reportNonFatal(outOfMemoryError2, "DB query failed: " + outOfMemoryError2.getMessage() + Arrays.toString(outOfMemoryError2.getStackTrace()));
                    IBGDbManager.access$300(this.i, "DB query failed due to: " + outOfMemoryError2.getMessage() + Arrays.toString(outOfMemoryError2.getStackTrace()));
                    return null;
                }
                IBGDiagnostics.reportNonFatal(exception2, "DB query failed: " + exception2.getMessage() + Arrays.toString(exception2.getStackTrace()));
                IBGDbManager.access$300(this.i, "DB query failed due to: " + exception2.getMessage() + Arrays.toString(exception2.getStackTrace()));
                return null;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
    public synchronized void beginTransaction() {
        Exception exception2;
        block5: {
            OutOfMemoryError outOfMemoryError2;
            block4: {
                IBGDbManager iBGDbManager = this;
                iBGDbManager.openDatabase();
                try {
                    if (iBGDbManager.databaseInitializedAndOpen()) {
                        if (!this.isDatabaseTransactionsEnabled()) return;
                        this.database.beginTransaction();
                        return;
                    }
                }
                catch (OutOfMemoryError outOfMemoryError2) {
                    break block4;
                }
                catch (Exception exception2) {
                    break block5;
                }
                this.logOperationFailedWarning("DB transaction failed");
                return;
            }
            IBGDiagnostics.reportNonFatal(outOfMemoryError2, "DB transaction failed: " + outOfMemoryError2.getMessage());
            this.logOperationFailedWarning("DB transaction failed due to: " + outOfMemoryError2.getMessage());
            return;
        }
        IBGDiagnostics.reportNonFatal(exception2, "DB transaction failed: " + exception2.getMessage());
        this.logOperationFailedWarning("DB transaction failed due to:" + exception2.getMessage());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
    public synchronized void endTransaction() {
        Exception exception2;
        block5: {
            OutOfMemoryError outOfMemoryError2;
            block4: {
                try {
                    if (this.databaseInitializedAndOpen()) {
                        if (!this.isDatabaseTransactionsEnabled()) return;
                        this.database.endTransaction();
                        return;
                    }
                }
                catch (OutOfMemoryError outOfMemoryError2) {
                    break block4;
                }
                catch (Exception exception2) {
                    break block5;
                }
                this.logOperationFailedWarning("DB end transaction not successful");
                return;
            }
            IBGDiagnostics.reportNonFatal(outOfMemoryError2, "DB end transaction not successful due to: " + outOfMemoryError2.getMessage());
            this.logOperationFailedWarning("DB end transaction not successful due to: " + outOfMemoryError2.getMessage());
            return;
        }
        IBGDiagnostics.reportNonFatal(exception2, "DB end transaction not successful due to: " + exception2.getMessage());
        this.logOperationFailedWarning("DB end transaction not successful due to: " + exception2.getMessage());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
    public synchronized void setTransactionSuccessful() {
        Exception exception2;
        block5: {
            OutOfMemoryError outOfMemoryError2;
            block4: {
                try {
                    if (this.databaseInitializedAndOpen()) {
                        if (!this.isDatabaseTransactionsEnabled()) return;
                        this.database.setTransactionSuccessful();
                        return;
                    }
                }
                catch (OutOfMemoryError outOfMemoryError2) {
                    break block4;
                }
                catch (Exception exception2) {
                    break block5;
                }
                this.logOperationFailedWarning("DB transaction not successful");
                return;
            }
            IBGDiagnostics.reportNonFatal(outOfMemoryError2, "DB transaction not successful due to: " + outOfMemoryError2.getMessage() + Arrays.toString(outOfMemoryError2.getStackTrace()));
            this.logOperationFailedWarning("DB transaction not successful due to: " + outOfMemoryError2.getMessage() + Arrays.toString(outOfMemoryError2.getStackTrace()));
            return;
        }
        IBGDiagnostics.reportNonFatal(exception2, "DB transaction not successful due to: " + exception2.getMessage() + Arrays.toString(exception2.getStackTrace()));
        this.logOperationFailedWarning("DB transaction not successful due to: " + exception2.getMessage() + Arrays.toString(exception2.getStackTrace()));
    }

    /*
     * WARNING - void declaration
     */
    public long queryNumEntries(@NonNull String tableName) {
        void var1_1;
        Long l2 = (Long)PoolProvider.getDatabaseExecutor().executeAndGet(new ReturnableRunnable((IBGDbManager)((Object)l2), (String)var1_1){
            final /* synthetic */ String a;
            final /* synthetic */ IBGDbManager b;
            {
                void var1_1;
                this.b = var1_1;
                this.a = string2;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Long run() {
                Exception exception2;
                block5: {
                    OutOfMemoryError outOfMemoryError2;
                    block4: {
                        i i2 = this;
                        i2.b.openDatabase();
                        try {
                            if (i2.b.databaseInitializedAndOpen()) {
                                return DatabaseUtils.queryNumEntries((SQLiteDatabase)this.b.database, (String)this.a);
                            }
                        }
                        catch (OutOfMemoryError outOfMemoryError2) {
                            break block4;
                        }
                        catch (Exception exception2) {
                            break block5;
                        }
                        IBGDbManager.access$300(this.b, "DB query num entries failed");
                        return -1L;
                    }
                    IBGDiagnostics.reportNonFatal(outOfMemoryError2, "DB query num entries failed: " + outOfMemoryError2.getMessage() + Arrays.toString(outOfMemoryError2.getStackTrace()));
                    IBGDbManager.access$300(this.b, "DB query num entries failed due to: " + outOfMemoryError2.getMessage());
                    return -1L;
                }
                IBGDiagnostics.reportNonFatalAndLog(exception2, "DB query num entries failed: " + exception2.getMessage() + Arrays.toString(exception2.getStackTrace()), "IBG-Core");
                IBGDbManager.access$300(this.b, "DB query num entries failed due to: " + exception2.getMessage() + Arrays.toString(exception2.getStackTrace()));
                return -1L;
            }
        });
        if (l2 == null) {
            return -1L;
        }
        return l2;
    }

    public synchronized boolean deleteDatabase(Context context) {
        dbHelper.close();
        return context.deleteDatabase(dbHelper.getDatabaseName());
    }
}

