/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Environment;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.library.Instabug;
import com.instabug.library.internal.servicelocator.CoreServiceLocator;
import com.instabug.library.internal.storage.executor.DeleteOperationExecutor;
import com.instabug.library.internal.storage.executor.ReadOperationExecutor;
import com.instabug.library.internal.storage.executor.WriteOperationExecutor;
import com.instabug.library.internal.storage.operation.DiskOperation;
import com.instabug.library.sessionreplay.di.a;
import com.instabug.library.util.FileUtils;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.extenstions.b;
import com.instabug.library.util.threading.PoolProvider;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutionException;
import kotlin.io.FilesKt;

public final class DiskUtils {
    public static final String TAG = "DiskUtils";
    private final Context context;

    /*
     * WARNING - void declaration
     */
    private DiskUtils(Context context) {
        void var1_1;
        this.context = var1_1;
    }

    public static File getInstabugInternalDirectory(Context context) {
        File file;
        Object object = DiskUtils.getInternalStoragePath(context);
        File file2 = file;
        if (!new File((String)object + "/instabug/").exists() && file2.mkdirs()) {
            try {
                new File(file2, ".nomedia").createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return file2;
            }
            return file2;
        }
        return file2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static File getInstabugDirectory(Context context, boolean createIfNotExist) {
        File file;
        Object object;
        if (context.getExternalFilesDir(null) != null && Environment.getExternalStorageState().equals("mounted")) {
            try {
                object = object.getExternalFilesDir(null).getAbsolutePath();
            }
            catch (NullPointerException nullPointerException) {
                object = DiskUtils.getInternalStoragePath(object);
                InstabugSDKLogger.w(TAG, "External storage not available, saving file to internal storage.");
            }
        } else {
            object = DiskUtils.getInternalStoragePath(object);
            InstabugSDKLogger.i(TAG, "External storage not available, saving file to internal storage.");
        }
        File file2 = file;
        if (!new File((String)object + "/instabug/").exists()) {
            void var1_1;
            if (var1_1 == false) {
                return null;
            }
            if (file2.mkdirs()) {
                try {
                    new File(file2, ".nomedia").createNewFile();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return file2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static synchronized File getInstabugLogDirectory(String directoryLogName, Context context, boolean createIfNotExist) {
        String string2;
        File file;
        void var2_2;
        Object object = DiskUtils.getInstabugDirectory(context, (boolean)var2_2);
        if (object == null) {
            return null;
        }
        object = ((File)object).getAbsolutePath().concat("/");
        File file2 = file;
        if (!new File(((String)object).concat(string2)).exists()) {
            if (var2_2 == false) {
                return null;
            }
            if (!file2.mkdir()) {
                InstabugSDKLogger.w(TAG, "failed logs directory to create");
                return file2;
            }
        }
        return file2;
    }

    public static String getInternalStoragePath(Context context) {
        return b.b(context).getAbsolutePath();
    }

    /*
     * WARNING - void declaration
     */
    public static void saveBitmapOnDisk(Bitmap bitmap, File file) throws IOException {
        void var1_1;
        if (bitmap != null && var1_1 != null) {
            Bitmap bitmap2;
            FileOutputStream fileOutputStream;
            InstabugSDKLogger.v("IBG-Core", "starting save viewHierarchy image, path: " + var1_1.getAbsolutePath());
            FileOutputStream fileOutputStream2 = fileOutputStream;
            fileOutputStream2((File)var1_1);
            bitmap2.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fileOutputStream2);
            fileOutputStream.close();
            InstabugSDKLogger.v("IBG-Core", "viewHierarchy image saved, path: " + var1_1.getAbsolutePath() + ", time in MS: " + System.currentTimeMillis());
            return;
        }
    }

    public static void cleanDirectory(File directory) {
        File[] fileArray;
        if (directory.exists() && fileArray.isDirectory() && (fileArray = fileArray.listFiles()) != null) {
            for (File file : fileArray) {
                if (!file.delete()) continue;
                InstabugSDKLogger.v("IBG-Core", "file deleted successfully, path: " + file.getPath());
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"RESOURCE_LEAK"})
    public static void copyFromUriIntoFile(@NonNull Context context, Uri source, File target) throws IOException {
        IOException iOException2;
        block10: {
            Object object;
            InputStream inputStream;
            BufferedInputStream bufferedInputStream = null;
            OutputStream outputStream = null;
            if (source != null && (inputStream = object.getContentResolver().openInputStream((Uri)inputStream)) != null) {
                BufferedInputStream bufferedInputStream2;
                bufferedInputStream = bufferedInputStream2;
                bufferedInputStream2 = new BufferedInputStream(inputStream);
            }
            if (bufferedInputStream != null) {
                void var2_4;
                InstabugSDKLogger.d(TAG, "Target file path: " + var2_4.getPath());
                inputStream = Uri.fromFile((File)var2_4);
                if (inputStream != null && (object = object.getContentResolver().openOutputStream((Uri)inputStream)) != null) {
                    BufferedOutputStream bufferedOutputStream;
                    outputStream = bufferedOutputStream;
                    bufferedOutputStream = new BufferedOutputStream((OutputStream)object);
                }
                if (outputStream != null) {
                    int n2;
                    object = new byte[32768];
                    while ((n2 = ((InputStream)bufferedInputStream).read((byte[])object)) > 0) {
                        ((BufferedOutputStream)outputStream).write((byte[])object, 0, n2);
                    }
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException2) {
                    break block10;
                }
            }
            if (bufferedInputStream == null) return;
            bufferedInputStream.close();
            return;
        }
        if (iOException2.getMessage() == null) return;
        InstabugSDKLogger.e(TAG, iOException2.getMessage(), iOException2);
    }

    public static void deleteFile(String fileLocalPath) {
        PoolProvider.postIOTask(() -> {
            String string2;
            new File(string2).delete();
        });
    }

    public static DiskUtils with(Context context) {
        Context context2;
        return new DiskUtils(context2);
    }

    public static boolean isFileExist(String path) {
        String string2;
        return new File(string2).exists();
    }

    public static void deleteSDKDirectory() {
        DiskUtils.deleteSDKDataHub();
        Object object = Instabug.getApplicationContext();
        if (object != null && ((File)(object = DiskUtils.getInstabugInternalDirectory((Context)object))).exists()) {
            Object object2 = object;
            FileUtils.deleteDirectory((File)object2);
            ((File)object2).delete();
            return;
        }
    }

    public static void deleteSDKDataHub() {
        block4: {
            InterruptedException interruptedException2;
            block3: {
                try {
                    CoreServiceLocator.getDataHubController().shutdown().get();
                }
                catch (ExecutionException executionException) {
                }
                catch (InterruptedException interruptedException2) {
                    break block3;
                }
                return;
                InstabugSDKLogger.e("IBG-Core", "Error deleting SDK data hub directory", executionException);
                break block4;
            }
            InstabugSDKLogger.e("IBG-Core", "Error deleting SDK data hub directory [Thread interrupted]", interruptedException2);
            Thread.currentThread().interrupt();
        }
    }

    public static void deleteSdkExternalDirectory() {
        Object object = Instabug.getApplicationContext();
        if (object != null && (object = DiskUtils.getInstabugDirectory((Context)object, false)) != null && ((File)object).exists()) {
            Object object2 = object;
            FileUtils.deleteDirectory((File)object2);
            ((File)object2).delete();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static File createStateTextFile(Context context, String fileNamePrefix) {
        void var1_1;
        Object object;
        StringBuilder stringBuilder = new StringBuilder().append(object.getFilesDir().getAbsolutePath());
        object = File.pathSeparator;
        return new File(stringBuilder.append((String)object).append((String)var1_1).append((String)object).append(System.currentTimeMillis()).append(".txt").toString());
    }

    public static void deleteCrashStateFiles() {
        DiskUtils.deleteStateFiles("crash_state");
    }

    public static void deleteNonfatalStateFiles() {
        DiskUtils.deleteStateFiles("non_fatal_state");
    }

    public static void deleteBugsStateFiles() {
        DiskUtils.deleteStateFiles("bug_state");
    }

    public static void deleteAppTerminationsStateFiles() {
        DiskUtils.deleteStateFiles("app_termination_state");
    }

    public static void deleteAllStateFiles() {
        Object object = Instabug.getApplicationContext();
        if (object != null) {
            object = object.getFilesDir().getParentFile();
            FilenameFilter filenameFilter = (dir, name) -> {
                void var1_1;
                return name.startsWith("files:") && var1_1.endsWith(".txt") && !var1_1.contains("non_fatal_state");
            };
            if (object != null && (object = ((File)object).listFiles(filenameFilter)) != null) {
                int n2 = ((Object)object).length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    ((File)object[i2]).delete();
                }
            }
        }
    }

    public static void deleteSessionReplayDirectory() {
        File[] fileArray = Instabug.getApplicationContext();
        if (fileArray != null) {
            File file;
            File file2 = file;
            if (new File(DiskUtils.getInternalStoragePath((Context)fileArray) + "/instabug/").exists() && (fileArray = file2.listFiles((dir, name) -> name.equals("session-replay"))) != null && fileArray.length > 0) {
                FilesKt.deleteRecursively((File)fileArray[0]);
                return;
            }
        }
    }

    public static void cleanseSRMonitoringDirectory() {
        a.e().d();
    }

    public static void deleteStateFiles(String filePrefix) {
        Object object = Instabug.getApplicationContext();
        if (object != null) {
            File[] fileArray;
            object = object.getFilesDir().getParentFile();
            fileArray = (arg_0, arg_1) -> DiskUtils.lambda$deleteStateFiles$3((String)fileArray, arg_0, arg_1);
            if (object != null && (fileArray = ((File)object).listFiles((FilenameFilter)fileArray)) != null) {
                int n2 = fileArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    fileArray[i2].delete();
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ boolean lambda$deleteStateFiles$3(String filePrefix, File dir, String name) {
        void var2_2;
        String string2;
        return name.startsWith("files:" + string2) && var2_2.endsWith(".txt");
    }

    /*
     * WARNING - void declaration
     */
    public ReadOperationExecutor readOperation(@NonNull DiskOperation<String, Void> operation) {
        void var1_1;
        return new ReadOperationExecutor((DiskOperation<String, Void>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public WriteOperationExecutor writeOperation(@NonNull DiskOperation<Uri, Context> operation) {
        void var1_1;
        return new WriteOperationExecutor(this.context, (DiskOperation<Uri, Context>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public DeleteOperationExecutor deleteOperation(@NonNull DiskOperation<Boolean, Void> operation) {
        void var1_1;
        return new DeleteOperationExecutor((DiskOperation<Boolean, Void>)var1_1);
    }
}

