/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.instacapture.screenshot;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.opengl.GLSurfaceView;
import android.os.Build;
import android.util.Pair;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import androidx.annotation.IdRes;
import androidx.annotation.Nullable;
import com.instabug.library.Instabug;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.instacapture.screenshot.FieldHelper;
import com.instabug.library.instacapture.screenshot.RootViewInfo;
import com.instabug.library.instacapture.screenshot.pixelcopy.a;
import com.instabug.library.instacapture.screenshot.pixelcopy.b;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.DisplayUtils;
import com.instabug.library.util.InstabugSDKLogger;
import io.reactivexport.Observable;
import io.reactivexport.ObservableEmitter;
import io.reactivexport.android.schedulers.AndroidSchedulers;
import io.reactivexport.functions.n;
import io.reactivexport.p;
import io.reactivexport.schedulers.Schedulers;
import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.opengles.GL10;

public final class ScreenshotTaker {
    private ScreenshotTaker() {
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Observable<Bitmap> getScreenshotBitmap(Activity activity, @Nullable @IdRes int[] ignoredViewsIds) {
        void var0_3;
        Object object;
        String string2;
        block6: {
            int n2;
            Activity activity2;
            if (activity == null) throw new IllegalArgumentException("Parameter activity cannot be null.");
            if (com.instabug.library.util.a.a(activity2)) {
                if (!SettingsManager.getInstance().shouldIgnoreFlagSecure()) throw new com.instabug.library.instacapture.exception.a("FLAG_SECURE is enabled for activity " + activity2.getClass().getName() + " . Not capturing screenshot.");
            }
            if (Build.VERSION.SDK_INT >= 26) {
                return b.b(activity2, (int[])string2);
            }
            object = activity2.getWindow().getDecorView();
            List<RootViewInfo> list = FieldHelper.getRootViews(activity2, (int[])string2);
            try {
                n2 = object.getWidth() * object.getHeight();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                break block6;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                break block6;
            }
            object = (long)(n2 * 4) < com.instabug.library.instacapture.utility.a.a((Context)activity2) ? Bitmap.createBitmap((int)object.getWidth(), (int)object.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888) : Bitmap.createBitmap((int)object.getWidth(), (int)object.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
            return ScreenshotTaker.drawRootsToBitmap(list, (Bitmap)object, (int[])string2, activity2);
        }
        string2 = "IBG-Core";
        object = var0_3.getMessage() == null ? "error while capturing screenshot" : var0_3.getMessage();
        InstabugSDKLogger.e(string2, (String)object, (Throwable)var0_3);
        return Observable.error((Throwable)var0_3);
    }

    /*
     * WARNING - void declaration
     */
    private static Observable<Bitmap> drawRootsToBitmap(List<RootViewInfo> viewRoots, Bitmap bitmap, @Nullable @IdRes int[] ignoredViewsIds, Activity activity) {
        void var3_3;
        void var2_2;
        void var1_1;
        List<RootViewInfo> list;
        if (viewRoots != null && list.size() > 1) {
            while (list.size() > 1) {
                List<RootViewInfo> list2 = list;
                list2.remove(list2.size() - 1);
            }
        }
        return Observable.fromIterable(list).flatMap(arg_0 -> ScreenshotTaker.lambda$drawRootsToBitmap$0((Bitmap)var1_1, (int[])var2_2, (Activity)var3_3, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private static Observable<Bitmap> drawRootToBitmap(RootViewInfo rootViewInfo, Bitmap bitmap, @Nullable @IdRes int[] ignoredViewsIds, Activity activity) {
        void var3_3;
        RootViewInfo rootViewInfo2;
        void var2_2;
        void var1_1;
        return Observable.create(arg_0 -> ScreenshotTaker.lambda$drawRootToBitmap$1(rootViewInfo, (Bitmap)var1_1, (int[])var2_2, arg_0)).observeOn(AndroidSchedulers.mainThread()).map(pair -> {
            void var1_1;
            RootViewInfo rootViewInfo2;
            Iterator iterator = ((HashMap)pair.second).keySet().iterator();
            while (iterator.hasNext()) {
                ((View)iterator.next()).setVisibility(4);
            }
            rootViewInfo2.getView().draw((Canvas)var1_1.first);
            return var1_1;
        }).observeOn(Schedulers.io()).map(arg_0 -> ScreenshotTaker.lambda$drawRootToBitmap$3(rootViewInfo2, (Activity)var3_3, (Bitmap)var1_1, arg_0)).observeOn(AndroidSchedulers.mainThread()).map(new n((Bitmap)var1_1){
            final /* synthetic */ Bitmap a;
            {
                this.a = bitmap;
            }

            public Bitmap a(HashMap viewIntegerHashMap) {
                for (Map.Entry entry : viewIntegerHashMap.entrySet()) {
                    ((View)entry.getKey()).setVisibility(((Integer)entry.getValue()).intValue());
                }
                return this.a;
            }
        }).subscribeOn(Schedulers.io());
    }

    public static boolean isVisible(View view) {
        Rect rect;
        View view2;
        if (view.getVisibility() != 0) {
            return false;
        }
        View view3 = view2;
        view2 = rect;
        rect = new Rect();
        view3.getGlobalVisibleRect((Rect)view2);
        Context context = Instabug.getApplicationContext();
        int n2 = context == null ? 0 : DisplayUtils.getDisplayWidthInPx(context);
        int n3 = context == null ? 0 : DisplayUtils.getDisplayHeightInPx(context);
        return view2.intersect(new Rect(0, 0, n2, n3));
    }

    public static Rect getVisibleRect(@Nullable View childView) {
        View view;
        Rect rect;
        Rect rect2 = rect;
        rect = new Rect();
        if (childView != null && view.getVisibility() == 0 && view.getRootView().getParent() != null) {
            if (!view.getGlobalVisibleRect(rect2)) {
                return new Rect(0, 0, 0, 0);
            }
            return rect2;
        }
        return new Rect(0, 0, 0, 0);
    }

    public static Rect getVisibleRect(@Nullable View childView, Rect rect) {
        View view;
        Rect rect2;
        Rect rect3 = rect2;
        rect2 = new Rect();
        if (childView != null && view.getVisibility() == 0 && view.getRootView().getParent() != null) {
            if (!view.getGlobalVisibleRect(rect3)) {
                return new Rect(0, 0, 0, 0);
            }
            return rect3;
        }
        return new Rect(0, 0, 0, 0);
    }

    /*
     * WARNING - void declaration
     */
    private static ArrayList<View> drawUnDrawableViews(View v2, Canvas canvas) {
        ArrayList<View> arrayList;
        View view;
        if (!(v2 instanceof ViewGroup)) {
            ArrayList<View> arrayList2 = new ArrayList<View>();
            arrayList2.add(view);
            return arrayList2;
        }
        ArrayList<View> arrayList3 = arrayList;
        arrayList = new ArrayList<View>();
        ViewGroup viewGroup = (ViewGroup)view;
        for (int i2 = 0; i2 < viewGroup.getChildCount(); ++i2) {
            void var1_1;
            ArrayList<View> arrayList4;
            View view2 = viewGroup.getChildAt(i2);
            ArrayList<View> arrayList5 = arrayList4;
            arrayList5();
            arrayList5.add(view);
            arrayList4.addAll(ScreenshotTaker.drawUnDrawableViews(view2, (Canvas)var1_1));
            int[] nArray = new int[2];
            view2.getLocationOnScreen(nArray);
            if (view2 instanceof TextureView) {
                ScreenshotTaker.drawTextureView((TextureView)view2, nArray, (Canvas)var1_1);
            }
            if (view2 instanceof GLSurfaceView) {
                ScreenshotTaker.drawGLSurfaceView((GLSurfaceView)view2, nArray, (Canvas)var1_1);
            }
            if (view2 instanceof WebView) {
                ScreenshotTaker.drawWebView((WebView)view2, (Canvas)var1_1);
            }
            arrayList3.addAll(arrayList5);
        }
        return arrayList3;
    }

    /*
     * WARNING - void declaration
     */
    public static void drawGLSurfaceView(GLSurfaceView surfaceView, int[] locationOnScreen, Canvas canvas) {
        InstabugSDKLogger.v("IBG-Core", "Drawing GLSurfaceView");
        if (surfaceView.getWindowToken() != null) {
            void var2_3;
            Paint paint;
            void var1_1;
            CountDownLatch countDownLatch;
            Object object;
            int n2 = object.getWidth();
            int n3 = object.getHeight();
            int[] nArray = new int[n2 * n3];
            IntBuffer intBuffer = IntBuffer.wrap(nArray);
            intBuffer.position(0);
            CountDownLatch countDownLatch2 = countDownLatch;
            countDownLatch2(1);
            object.queueEvent(() -> {
                void var3_3;
                void var2_2;
                void var1_1;
                int n2;
                EGL10 eGL10 = (EGL10)EGLContext.getEGL();
                eGL10.eglWaitGL();
                GL10 gL10 = (GL10)eGL10.eglGetCurrentContext().getGL();
                gL10.glFinish();
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    InstabugSDKLogger.e("IBG-Core", "Something went wrong" + interruptedException);
                }
                gL10.glReadPixels(0, 0, n2, (int)var1_1, 6408, 5121, (Buffer)var2_2);
                var3_3.countDown();
            });
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                InstabugSDKLogger.e("IBG-Core", "Something went wrong" + interruptedException);
            }
            object = new int[n2 * n3];
            int n4 = 0;
            int n5 = 0;
            while (n4 < n3) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    int n6 = nArray[n4 * n2 + i2];
                    int n7 = n6 >> 16 & 0xFF;
                    int n8 = n6 << 16 & 0xFF0000;
                    n7 = n6 & 0xFF00FF00 | n8 | n7;
                    object[(n3 - n5 - 1) * n2 + i2] = (GLSurfaceView)n7;
                }
                ++n4;
                ++n5;
            }
            Bitmap bitmap = Bitmap.createBitmap((int[])object, (int)n2, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            void v4 = var1_1;
            object = paint;
            new Paint().setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_ATOP));
            float f2 = (float)v4[0];
            var2_3.drawBitmap(bitmap, f2, (float)v4[1], (Paint)object);
            bitmap.recycle();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void drawTextureView(TextureView textureView, int[] locationOnScreen, Canvas canvas) {
        OutOfMemoryError outOfMemoryError2;
        block8: {
            block7: {
                Paint paint;
                void var1_2;
                void var2_4;
                TextureView textureView2;
                InstabugSDKLogger.v("IBG-Core", "Drawing TextureView");
                try {
                    textureView2 = textureView.getBitmap();
                    if (textureView2 == null) break block7;
                }
                catch (OutOfMemoryError outOfMemoryError2) {}
                TextureView textureView3 = textureView2;
                void v12 = var2_4;
                TextureView textureView4 = textureView2;
                void v3 = var1_2;
                void v4 = v3;
                void v5 = v3;
                textureView2 = paint;
                new Paint().setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_ATOP));
                float f2 = (float)v4[0];
                float f3 = (float)v5[1];
                v12.drawBitmap((Bitmap)textureView4, f2, f3, (Paint)textureView2);
                textureView3.recycle();
                return;
                break block8;
            }
            return;
        }
        InstabugCore.reportError(outOfMemoryError2, "Drawing textureView failed due to an OOM: " + outOfMemoryError2.getMessage());
        InstabugSDKLogger.e("IBG-Core", "OOM while taking screenshot", outOfMemoryError2);
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static void drawWebView(WebView webView, Canvas canvas) {
        int n2 = webView.getLayerType();
        if (n2 == 2) {
            WebView webView2;
            WebView webView3 = webView2;
            webView3.setLayerType(0, null);
            webView3.setDrawingCacheEnabled(true);
            webView3.buildDrawingCache(true);
            Bitmap bitmap = webView3.getDrawingCache();
            if (bitmap != null) {
                Paint paint;
                Paint paint2;
                void v12 = paint2;
                paint2 = paint;
                new Paint().setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_ATOP));
                int[] nArray = new int[2];
                webView2.getLocationOnScreen(nArray);
                float f2 = nArray[0];
                v12.drawBitmap(bitmap, f2, (float)nArray[1], paint2);
                bitmap.recycle();
            }
            WebView webView4 = webView2;
            webView4.setDrawingCacheEnabled(false);
            webView4.setLayerType(n2, null);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ HashMap lambda$drawRootToBitmap$3(RootViewInfo rootViewInfo, Activity activity, Bitmap bitmap, Pair pair) throws Exception {
        void var3_3;
        ScreenshotTaker.drawUnDrawableViews(rootViewInfo.getView(), (Canvas)var3_3.first);
        if (SettingsManager.getInstance().getShouldCaptureDialog()) {
            void var2_2;
            void var1_1;
            a.a((Activity)var1_1, (Bitmap)var2_2);
        }
        return (HashMap)var3_3.second;
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$drawRootToBitmap$1(RootViewInfo rootViewInfo, Bitmap bitmap, int[] ignoredViewsIds, ObservableEmitter emitter) throws Exception {
        void var3_3;
        Pair pair;
        void var2_2;
        HashMap<View, Integer> hashMap;
        Canvas canvas;
        RootViewInfo rootViewInfo2;
        HashMap<View, Integer> hashMap2;
        if ((rootViewInfo.getLayoutParams().flags & 2) == 2) {
            new Canvas((Bitmap)hashMap2).drawARGB((int)(rootViewInfo2.getLayoutParams().dimAmount * 255.0f), 0, 0, 0);
        }
        Canvas canvas2 = canvas;
        canvas2((Bitmap)hashMap2);
        canvas.translate((float)rootViewInfo2.getLeft(), (float)rootViewInfo2.getTop());
        hashMap2 = hashMap;
        hashMap = new HashMap<View, Integer>();
        if (var2_2 != null) {
            for (int i2 = 0; i2 < ((void)var2_2).length; ++i2) {
                View view = rootViewInfo2.getView().findViewById((int)var2_2[i2]);
                if (view == null) continue;
                View view2 = view;
                hashMap2.put(view2, view2.getVisibility());
            }
        }
        rootViewInfo2 = pair;
        pair = new Pair((Object)canvas2, hashMap2);
        var3_3.onNext(rootViewInfo2);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ p lambda$drawRootsToBitmap$0(Bitmap bitmap, int[] ignoredViewsIds, Activity activity, RootViewInfo rootViewInfo) throws Exception {
        void var2_2;
        void var1_1;
        Bitmap bitmap2;
        return ScreenshotTaker.drawRootToBitmap(rootViewInfo, bitmap2, (int[])var1_1, (Activity)var2_2);
    }
}

