package com.instabug.library.util

import android.net.Uri
import com.instabug.library.Feature
import com.instabug.library.IBGFeature
import com.instabug.library.Instabug
import com.instabug.library.core.InstabugCore
import com.instabug.library.model.ConsoleLog
import com.instabug.library.model.Report
import com.instabug.library.model.State

fun State.updateFromReport(report: Report) {
    updateStateMetadataFromReport(report)
    updateStateLogsAndAttachmentsFromReport(report)
}

public fun State.updateStateMetadataFromReport(report: Report) {
    appendTags(report.tags)
    appendUserAttributes(report.userAttributes)
}

public fun State.updateStateLogsAndAttachmentsFromReport(report: Report) {
    appendConsoleLogs(report.consoleLog)
    appendUserData(report.userData)
    updateAttachments(report.fileAttachments)
}

private fun State.appendTags(reportTags: List<String>) {
    val separator = ", "
    val reportTagsString = reportTags.joinToString(separator)
    tags = tags?.takeUnless { it.isBlank() }?.let { "$it$separator$reportTagsString" } ?: reportTagsString
}

private fun State.appendConsoleLogs(reportConsoleLogs: List<ConsoleLog>) {
    appendConsoleLog(reportConsoleLogs)
}

private fun updateAttachments(attachments: Map<Uri, String>) =
    attachments.entries.forEach { Instabug.addFileAttachment(it.key, it.value) }

private fun State.appendUserAttributes(attributes: HashMap<String, String>) {
    userAttributes = ReportHelper.getUserAppendedAttributes(attributes)
}

private fun State.appendUserData(reportUserData: String?) =
    reportUserData
        ?.takeIf { InstabugCore.getFeatureState(IBGFeature.USER_DATA) == Feature.State.ENABLED }
        ?.let { userData = it }

fun State.dropLogs() {
    networkLogs = "[]"
    instabugLog = "[]"
    clearConsoleLogs()
    clearUserSteps()
    userEvents = "[]"
}