package com.instabug.library.util;

import android.Manifest;
import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageManager;
import android.media.AudioManager;

import com.instabug.library.tracking.InstabugInternalTrackingDelegate;

import androidx.core.content.ContextCompat;

/**
 * Created by mNagy on 1/18/17.
 */

public class MicUtils {

    public static void muteMic(Context context) {
        AudioManager audioManager = (AudioManager) context.getSystemService(Context.AUDIO_SERVICE);
        audioManager.setMode(AudioManager.MODE_NORMAL);
        if (!audioManager.isMicrophoneMute()) {
            audioManager.setMicrophoneMute(true);
        }
    }

    public static void unmuteMic(Context context) {
        AudioManager audioManager = (AudioManager) context.getSystemService(Context.AUDIO_SERVICE);
        audioManager.setMode(AudioManager.MODE_NORMAL);
        if (audioManager.isMicrophoneMute()) {
            audioManager.setMicrophoneMute(false);
        }
    }

    public static boolean isMicrophoneMute(Context context) {
        AudioManager audioManager = (AudioManager) context.getSystemService(Context.AUDIO_SERVICE);
        audioManager.setMode(AudioManager.MODE_NORMAL);
        return audioManager.isMicrophoneMute();
    }

    public static boolean isAudioPermissionGranted() {
        Activity currentActivity = InstabugInternalTrackingDelegate.getInstance().getCurrentActivity();
        return currentActivity != null
                && ContextCompat.checkSelfPermission(currentActivity, Manifest.permission.RECORD_AUDIO)
                == PackageManager.PERMISSION_GRANTED;
    }
}
