package com.instabug.library.util;

import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.view.View;

import java.util.Locale;

import androidx.annotation.NonNull;

/**
 * Created by mohamedzakaria on 7/25/17.
 */

public class LocaleHelper {
    public static boolean isRTL(@NonNull Context context) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1 && context != null) {
            Configuration config = context.getResources().getConfiguration();
            if (config.getLayoutDirection() == View.LAYOUT_DIRECTION_RTL) {
                return true;
            } else {
                return false;
            }
        } else {
            return isRTL(Locale.getDefault());
        }
    }

    public static boolean isRTL(Locale locale) {
        final int directionality = Character.getDirectionality(locale.getDisplayName().charAt(0));
        return directionality == Character.DIRECTIONALITY_RIGHT_TO_LEFT ||
                directionality == Character.DIRECTIONALITY_RIGHT_TO_LEFT_ARABIC;
    }
}