package com.instabug.library.util

import com.instabug.library.performanceclassification.DevicePerformanceClassHelper

interface LimitConstraintApplier {
    fun applyConstraints(originalLimit: Long): Long
    fun applyConstraints(originalLimit: Int): Int
}


class LimitConstraintsApplierImpl(
    private val devicePerformanceClassHelper: DevicePerformanceClassHelper
) : LimitConstraintApplier {
    override fun applyConstraints(originalLimit: Long) =
        applyDevicePerformanceConstraint(originalLimit).toLong()

    override fun applyConstraints(originalLimit: Int): Int = applyDevicePerformanceConstraint(
        originalLimit.toLong()
    ).toInt()


    private fun applyDevicePerformanceConstraint(originalLimit: Long) =
        (devicePerformanceClassHelper.getDeviceTrimmingPercentage() * originalLimit).toLong()
}