package com.instabug.library.util;

import android.content.Context;
import android.text.format.DateFormat;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.instabug.library.core.InstabugCore;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

/**
 * Created by vezikon on 11/25/15.
 */
public class InstabugDateFormatter {

    public static long getCurrentUTCTimeStampInSeconds() {
        return System.currentTimeMillis() / 1000;
    }

    public static long getCurrentUTCTimeStampInMiliSeconds() {
        return System.currentTimeMillis();
    }

    public static String getCurrentDateAsString() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(calendar.getTime());
    }

    public static String formatUTCDate(long UTCDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(UTCDate * 1000);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(calendar.getTime());
    }

    public static String convertUnixTimeToFormattedDate(long UNIXTime) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(convertUnixTimeToDate(UNIXTime));
    }

    public static String convertUnixTimeToFormattedDate(long UNIXTime, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format, Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(convertUnixTimeToDate(UNIXTime));
    }

    public static Date convertUnixTimeToDate(long UNIXTime) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(UNIXTime);
        return calendar.getTime();
    }

    public static String formatMessageDate(@NonNull Context context, long messageUTCDate) {
        boolean is24HourFormat = DateFormat.is24HourFormat(context);
        String format = is24HourFormat ? "dd-MMM HH:mm" : "dd-MMM hh:mm a";
        SimpleDateFormat output = new SimpleDateFormat(format, InstabugCore.getLocale(context));
        return output.format(messageUTCDate * 1000);
    }

    public static String formatConversationLastMessageDate(Context context, long conversationLastMessageToUTCDate) {
        SimpleDateFormat output = new SimpleDateFormat("dd MMM", InstabugCore.getLocale(context));
        return output.format(conversationLastMessageToUTCDate * 1000);
    }

    public static Date getStandardizedDate(Date date) {
        return new Date(date.getTime());
    }

    @Nullable
    public static Date getDate(String dateText) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date date;

        try {
            date = sdf.parse(dateText);
            return date;
        } catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }
}
