package com.instabug.library.sessionV3.providers

import android.app.ActivityManager
import android.app.ActivityManager.RunningAppProcessInfo.IMPORTANCE_FOREGROUND
import android.content.Context
import com.instabug.library.Instabug

interface BackgroundStateProvider {
    val isAppStartedInBackground: Boolean
}

object BackgroundStateProviderImpl : BackgroundStateProvider {
    private val context
        get() = Instabug.getApplicationContext()

    override val isAppStartedInBackground: Boolean
        get() = context
            ?.run { getSystemService(Context.ACTIVITY_SERVICE) as ActivityManager? }
            ?.runningAppProcesses
            ?.takeUnless { it.isEmpty() }
            ?.firstOrNull { appProcess -> appProcess.isInForeground(context!!) }
            ?.let { false }
            ?: true

    private fun ActivityManager.RunningAppProcessInfo.isInForeground(
        context: Context
    ) = importance == IMPORTANCE_FOREGROUND && processName == context.packageName
}