package com.instabug.library.screenshot.analytics

import com.instabug.library.map.Mapper
import org.json.JSONObject

class ScreenShotAnalyticsMapper : Mapper<ScreenshotAnalytics, JSONObject> {
    companion object {
        const val screenShotCaptureCount = "stc"
        const val screenShotDroppedCount = "sdc"
        const val capturedErrorCodes = "e"
    }

    override fun map(from: ScreenshotAnalytics) = JSONObject().apply {
        put(screenShotCaptureCount, from.screenShotCaptureCount)
        put(screenShotDroppedCount, from.screenShotDroppedCount)
        val errorCodes = JSONObject()
        from.capturedErrorCodes.forEach { (key, value) ->
            errorCodes.put(key, value)
        }
        put(capturedErrorCodes, errorCodes)
    }
}
