package com.instabug.library.networkv2.service;

import android.annotation.SuppressLint;

import androidx.annotation.VisibleForTesting;

import com.instabug.library.Constants;
import com.instabug.library.IBGNetworkWorker;
import com.instabug.library.networkv2.NetworkManager;
import com.instabug.library.networkv2.RequestResponse;
import com.instabug.library.networkv2.request.Endpoints;
import com.instabug.library.networkv2.request.Request;
import com.instabug.library.networkv2.request.RequestMethod;
import com.instabug.library.networkv2.request.RequestParameter;
import com.instabug.library.networkv2.request.RequestType;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.user.UserManager;
import com.instabug.library.util.InstabugSDKLogger;

import org.json.JSONException;

/**
 * Created by Tarek360 on 1/11/2016.
 */
public class MigrateUUIDService {
    @VisibleForTesting
    static final String KEY_OLD_UUID = "old_uuid";
    @VisibleForTesting
    static final String KEY_NEW_UUID = "new_uuid";
    private static final String KEY_APP_TOKEN = "application_token";
    @VisibleForTesting
    static final String KEY_USERNAME = "name";
    @VisibleForTesting
    static final String KEY_EMAIL = "email";

    public final static String MIGRATE_UUID_ERROR = "migrateUUID request got error: ";

    private static MigrateUUIDService INSTANCE;
    private NetworkManager networkManager;

    /**
     * Returns the current singleton instance of this class.
     *
     * @return singleton instance of MigrateUUIDService
     */
    public synchronized static MigrateUUIDService getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MigrateUUIDService();
        }
        return INSTANCE;
    }

    private MigrateUUIDService() {
        networkManager = new NetworkManager();
    }


    public void migrateUUID(String oldUUID, String newUUID,
                            final Request.Callbacks<String, Throwable> requestCallbacks)
            throws JSONException {
        if(oldUUID != null && newUUID != null && requestCallbacks != null) {
            // Create migrateUUID request.
            Request migrateUUIDRequest = buildMigrateUUIDRequest(oldUUID, newUUID);
            // Do request with NORMAL request type.
            networkManager.doRequest(IBGNetworkWorker.CORE, RequestType.NORMAL, migrateUUIDRequest, new Request.Callbacks<RequestResponse, Throwable>() {
                @Override
                public void onSucceeded(RequestResponse requestResponse) {
                    if (requestResponse != null && requestResponse.getResponseBody() != null) {
                        InstabugSDKLogger.d(Constants.LOG_TAG, "migrateUUID request Succeeded, Response code: " + requestResponse.getResponseCode());
                        InstabugSDKLogger.v(Constants.LOG_TAG, "Response body: " + requestResponse.getResponseBody());
                        requestCallbacks.onSucceeded((String) requestResponse.getResponseBody());
                    }
                }

                @Override
                public void onFailed(Throwable error) {
                    InstabugSDKLogger.e(Constants.LOG_TAG, MIGRATE_UUID_ERROR + error.getMessage(), error);
                    requestCallbacks.onFailed(error);
                }
            });
        }
    }

    @VisibleForTesting
    @SuppressLint("ERADICATE_PARAMETER_NOT_NULLABLE")
    Request buildMigrateUUIDRequest(String oldUUID,
                                    String newUUID) {

        return new Request.Builder()
                .hasUuid(false)
                .endpoint(Endpoints.MIGRATE_UUID)
                .method(RequestMethod.PUT)
                .addParameter(new RequestParameter(KEY_OLD_UUID, oldUUID))
                .addParameter(new RequestParameter(KEY_NEW_UUID, newUUID))
                .addParameter(new RequestParameter(KEY_USERNAME, UserManager.getIdentifiedUsername()))
                .addParameter(new RequestParameter(KEY_EMAIL, UserManager.getIdentifiedUserEmail()))
                .build();
    }
}
